
/**
 *
 * This is the abstract class to implement to create a procedure to run
 * on the light panel. The function in which to implement your controlling code
 * is run(). This method is run by the Fasad-program as many times it takes to 
 * fulfill its time quota.
 * 
 * Your class MUST have a constructor which only takes fasad as parameter like
 * public RunningLights(Fasad fasad) {
 *      super(fasad);
 * }
 * 
 * @author Gussoh
 */
public abstract class Procedure {
    
    private Fasad fasad;
    public static final int FOREVER = Integer.MAX_VALUE;
    
    
    public Procedure(Fasad fasad) {
        this.fasad = fasad;
    }
    
    /**
     * 
     * @return A name of the procedure
     */
    public abstract String getName();
    
    /**
     * 
     * @return A short description of the procedure
     */
    public abstract String getDescription();
    
    /**
     * The preferred duration of this procedure before continuing with next.
     * Return Procedure.FOREVER for forever.
     * @return Preferred duration of procedure in seconds
     */
    public abstract int getPreferredDuration();
    
    /**
     * Runs ONE iteration of the procedure. This will be called for as long as the
     * procedure is running. Use setLights() to control the lights.
     * 
     * @throws java.lang.Exception
     */
    public abstract void run() throws Exception;
    
    /**
     * Set what lights to light up. This method takes about 350ms to execute.
     * @param lights An two-dimensional array (boolean[3][5]) of boolean values of what lights to turn on.
     */
    public void setLights(boolean[][] lights) {
        fasad.setLights(lights);
    }
    
    @Override
    public String toString() {
        return getName();
    }
}
