shared float4x4 World          : WORLD          < string SasBindAddress = "Sas.Skeleton.MeshToJointToWorld[0]"; >;
shared float4x4 View           : VIEW           < string SasBindAddress = "Sas.Camera.WorldToView"; >;
shared float4x4 Projection     : PROJECTION     < string SasBindAddress = "Sas.Camera.Projection"; >;
shared float3   CameraPosition : CAMERAPOSITION < string SasBindAddress = "Sas.Camera.Position"; >;
shared float4   Time           : TIME           < string SasBindAddress = "Sas.Time.Now"; >;
shared float3   LightDir       : DIRECTION      < string SasBindAddress = "Sas.DirectionalLight[0].Direction"; >;

//===========================================================================
float2 MapToTexCoord (float2 coord) {
    return (float2(coord.x, -coord.y) + 1) * 0.5f;
}
texture2D tex0 <
    string Name = "diffuse";
    string SasResourceAddress = "sprite.jpg";
>;

sampler2D sampler0 <
    string Texture = "tex0";
> = sampler_state{
    Texture   = <tex0>;
    AddressU  = Wrap;
    AddressV  = Wrap;
    MagFilter = Linear;
    MinFilter = Linear;
    MipFilter = Linear;
};

//===========================================================================
void VertexShader1 (
    float3 position : POSITION,
    out float4 oPos : POSITION
) {
    oPos = mul(mul(mul(float4(position, 1), World), View), Projection);
    oPos.r*=1.5;
    oPos.g*=1.5;
}

//===========================================================================
float4 PixelShader1 (
    float2 texCoord0 : TEXCOORD0,
    float3 position : POSITION
) : COLOR {
    float4 color = 0.05*tex2D(sampler0, texCoord0);
    color.a=1;
    return color;
}


technique T0 < string SortTri = "Off"; > {
    pass P0 <
	   string TexGen[] = {"texCoord0"};
    > {
        CullMode         = none;
        AlphaBlendEnable = true;
        AlphaTestEnable  = false;
        SrcBlend         = one;
        DestBlend        = one;
        BlendOp          = add;
        PixelShader      = compile ps_1_1 PixelShader1();
        VertexShader     = compile vs_1_1 VertexShader1();
    }
}
