shared float4x4 World          : WORLD          < string SasBindAddress = "Sas.Skeleton.MeshToJointToWorld[0]"; >;
shared float4x4 View           : VIEW           < string SasBindAddress = "Sas.Camera.WorldToView"; >;
shared float4x4 Projection     : PROJECTION     < string SasBindAddress = "Sas.Camera.Projection"; >;
shared float3   CameraPosition : CAMERAPOSITION < string SasBindAddress = "Sas.Camera.Position"; >;
shared float4   Time           : TIME           < string SasBindAddress = "Sas.Time.Now"; >;
shared float3   LightDir       : DIRECTION      < string SasBindAddress = "Sas.DirectionalLight[0].Direction"; >;

//===========================================================================
float2 MapToTexCoord (float2 coord) {
    return (float2(coord.x, -coord.y) + 1) * 0.5f;
}

//===========================================================================
void VertexShader0 (
    float3 position : POSITION,
    out float4 oPos : POSITION
) {
    oPos = mul(mul(mul(float4(position, 1), World), View), Projection);
}

//===========================================================================
float4 PixelShader0 () : COLOR
{
    float4 op3 = float4(0.16, 0.12, 0, 1);
    return op3;
}

//===========================================================================
void VertexShader1 (
    float3 position : POSITION,
    out float4 oPos : POSITION
) {
    oPos = mul(mul(mul(float4(position, 1), World), View), Projection);
}

//===========================================================================
float4 PixelShader1 (
) : COLOR {
    float const5 = 0.195745f;
    return float4(const5, const5, const5, 1);
}

technique T0 < string SortTri = "Off"; > {
    pass P0 <
    > {
        CullMode         = none;
        AlphaBlendEnable = true;
        AlphaTestEnable  = false;
        SrcBlend         = one;
        DestBlend        = one;
        BlendOp          = add;
        PixelShader      = compile ps_1_1 PixelShader0();
        VertexShader     = compile vs_1_1 VertexShader0();
    }
    pass P1 <
    > {
        CullMode         = none;
        AlphaBlendEnable = true;
        AlphaTestEnable  = false;
        SrcBlend         = one;
        DestBlend        = one;
        BlendOp          = add;
        PixelShader      = compile ps_1_1 PixelShader1();
        VertexShader     = compile vs_1_1 VertexShader1();
        FillMode         = WireFrame;
    }
}
