struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_Alpha : ALPHA;
float V_Var1 : VAR1; // Intens

float4 PSHiPass(VS_OUTPUT In) : COLOR0
{
  float4 color;
  float  value;
  color     = tex2D(Sampler, In.Tex0);
  color.a   = V_Alpha * color.a;
  value     = (color.r+color.g+color.b)/3.0;
  if (value > V_Var1)
    color = 0;
  return color;
}

float4 PSLoPass(VS_OUTPUT In) : COLOR0
{
  float4 color;
  float  value;
  color     = tex2D(Sampler, In.Tex0);
  color.a   = V_Alpha * color.a;
  value     = (color.r+color.g+color.b)/3.0;
  if (value < V_Var1)
    color = 0;
  return color;
}


technique HiPass
{
  pass PassEmboss
  {
    PixelShader = compile ps_1_4 PSHiPass();
  }
}

technique LowPass
{
  pass PassEmboss
  {
    PixelShader = compile ps_1_4 PSLoPass();
  }
}
