struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_Alpha : ALPHA;
float V_Var1 : VAR1;
float V_Var2 : VAR2;
float4 PS(VS_OUTPUT In) : COLOR0
{
  float2 xy=(In.Tex0.xy-0.5)*V_Var1*V_Var1*4+0.5;
  if(V_Var2==0){
    xy=saturate(xy*0.99)+0.005;
  }else{
    xy=frac(xy);
  }
  float4 color = tex2D(Sampler, xy);
  color.a = V_Alpha * color.a;
  return color;
}

technique Zoom
{
  pass PassZoom
  {
    PixelShader = compile ps_2_0 PS();
  }
}
