texture g_txSrcColor;
texture g_txSrcNormal;
texture g_txSrcPosition;
texture g_txSrcVelocity;

texture g_txSceneColor;
texture g_txSceneNormal;
texture g_txScenePosition;
texture g_txSceneVelocity;

sampler2D g_samSrcColor = sampler_state {
	Texture 	= <g_txSrcColor>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSrcNormal = sampler_state {
	Texture 	= <g_txSrcNormal>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSrcPosition = sampler_state {
	Texture 	= <g_txSrcPosition>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSrcVelocity = sampler_state {
	Texture 	= <g_txSrcVelocity>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};

sampler2D g_samSceneColor = sampler_state {
	Texture 	= <g_txSceneColor>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSceneNormal = sampler_state {
	Texture 	= <g_txSceneNormal>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samScenePosition = sampler_state {
	Texture 	= <g_txScenePosition>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSceneVelocity = sampler_state {
	Texture 	= <g_txSceneVelocity>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};

float Blend = 0.5f;

float4 Combine( float2 Tex : TEXCOORD0,
                float2 Tex2 : TEXCOORD1 ) : COLOR0 {
	float3 BlendFactor = float3( Blend, Blend, Blend );
	float3 BlendFactorInv = float3( 1.0f - Blend, 1.0f - Blend, 1.0f - Blend );
	float  BlendInv = 1.0 - Blend;
	float3 ColorOrig;
	ColorOrig = 	tex2D( g_samSceneColor, Tex ) * Blend;
	ColorOrig += 	tex2D( g_samSrcColor, Tex ) * BlendInv;
	return float4( ColorOrig, 1.0f );
}

technique PostProcess<
	string Parameter0 = "Blend";
	float4 Parameter0Def = float4( 0.5, 0, 0, 0 );
	int 	 Parameter0Size = 1;
	string Parameter0Desc = " (float)";    
> {
	pass p0 {
	  AlphaBlendEnable 	= true;
	  SrcBlend 					= SrcAlpha;
	  DestBlend 				= InvSrcAlpha;
	  CullMode 					= CCW;
	  FillMode 					= Solid;
	  FogEnable 				= False;
	  VertexShader 			= null;
	  PixelShader 			= compile ps_2_0 Combine();
	  ZEnable 					= false;
	}
}
