float4x4 matWorldViewProjection;

//depth 
float Focus = .7f;
float Eksponent = 1;
float FarClip = 250.f;
float FallOff = 3.f;

//dofblur
float2 pixelstep = {1.f/800.f, 1.f/600.f};

//anim
float anim = 0.f;
float amplitude = 0.f;

texture tex0, tex1;
 

sampler2D a = 
sampler_state
{
	texture = (tex1); 
	MipFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressV = Wrap; AddressU = Wrap;
};
sampler2D depth = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MipFilter = Linear;
	AddressV = Wrap; AddressU = Wrap;
};



void vs_depth(in float4 ipos : POSITION,			 
			 out float4 opos : POSITION, 
			 out float  depth : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	depth =  min(1, pow(abs((length(opos)/FarClip)-Focus)*FallOff, Eksponent));
}

float4 ps_depth(in float depth : TEXCOORD0) : COLOR0
{
	return depth;
}


//dof
void vs_dof(in float4 ipos : POSITION,
			    in float2 itex : TEXCOORD0,
			    out float4 opos : POSITION,
			    out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; 
	otex.y += 1.f;
}

float4 ps_dof(in float2 tex : TEXCOORD0) : COLOR0
{
	return tex2D(a, tex); 
	/*
	float  pixelalpha = (tex2D(depth, tex));
	float4 blur = tex2D(a, tex);
	float4 regular = tex2D(b, tex);
	float4 pixel = blur*pixelalpha + regular*(1.f-pixelalpha);
	return pixel;
	*/
}


	


technique DepthOfField
{
	pass Depth
	{
		VertexShader = compile vs_2_0 vs_depth();
		PixelShader  = compile ps_2_0 ps_depth();
	}
	
	pass Dof
	{
		VertexShader = compile vs_2_0 vs_dof();
		PixelShader  = compile ps_2_0 ps_dof();
	}
}