float4x4 matWorldViewProjection;
float4x4 matWorldView;
float3 CameraPosition = {1.f, 1.f, 1.f};
float treshold = 1.4f;


//fog
float FogEnd = 200.f;
float FogStart = 0.f;
float4x4 matWorld;

//woot
float4x4 matView; 
float3 Light1 = {1.f, 100.f, 1.f};



texture tex1;
sampler2D normalmap =
sampler_state
{
	texture = (tex1);
	AddressU = Wrap;
	AddressV = Wrap;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear; 
};

/* per pixel */
void vs_fresnel(in float4 ipos : POSITION,
				in float3 inorm : NORMAL,
				in float2 itex : TEXCOORD0,
				
				out float4 opos : POSITION,
				out float2 otex : TEXCOORD0,
				out float3 onorm : TEXCOORD1,
				out float3 lightvec : TEXCOORD2,
				out float  fog : TEXCOORD3)
{
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(inorm, matWorldView));
	otex = itex;
	lightvec = normalize(CameraPosition - mul(ipos, matWorldView));
	fog = 1.f-clamp( (length(CameraPosition-mul(ipos, matWorld))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
}

float4 ps_fresnel(in float2 tex : TEXCOORD0,
				  in float3 normal : TEXCOORD1,
				  in float3 lightvec : TEXCOORD2) : COLOR0
{

	float diffuse =  1.f-clamp(0.f, 1.f, dot( normalize(normal), lightvec.xyz)*treshold);
	return float4(diffuse, diffuse, diffuse, 1.f);
}

float4 ps_fresnelfog(in float2 tex : TEXCOORD0,
				  in float3 normal : TEXCOORD1,
				  in float3 lightvec : TEXCOORD2,
				  in float  fog : TEXCOORD3) : COLOR0
{

	float diffuse =  1.f-clamp(0.f, 1.f, dot( normalize(normal), lightvec.xyz)*treshold);
	return float4(diffuse, diffuse, diffuse, 1.f)*fog;
}

float4 ps_fresnelfoginv(in float2 tex : TEXCOORD0,
				  in float3 normal : TEXCOORD1,
				  in float3 lightvec : TEXCOORD2,
				  in float  fog : TEXCOORD3) : COLOR0
{
	//return float4(normal.xyz, 1.f);
	//return float4(lightvec.xyz, 1.f);
	//float dif = dot(normal, 1.f-lightvec.xyz);
	//return float4(dif, dif, dif, dif);
	
	float diffuse =  1.f-clamp(0.f, 1.f, dot( normalize(-1.f*normal), lightvec.xyz)*1.f);
	return float4(diffuse, diffuse, diffuse, 1.f)*fog*.8f;
}

technique fresnel
{
	pass diffuse
	{
		VertexShader = compile vs_2_0 vs_fresnel();
		PixelShader  = compile ps_2_0 ps_fresnel();
	}
	
	pass confog
	{
		VertexShader = compile vs_2_0 vs_fresnel();
		PixelShader = compile ps_2_0  ps_fresnelfog();
	}
	
	pass invert
	{
		VertexShader = compile vs_2_0 vs_fresnel();
		PixelShader = compile ps_2_0  ps_fresnelfoginv();
	}
}
