float4x4 matProjection;

float2 texeloffset = {.5f/400.f, .5f/300.f}; 
float factor = 1.f; 
float mfactor = 1.f;
float2 begin = {1.f/400.f, 1.f/300.f}; 


texture tex1;
sampler2D src = 
sampler_state
{
	texture = (tex1);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp; 
};

void vs_guassian(in float4 ipos : POSITION,
				 in float2 itex : TEXCOORD0,
				 out float4 opos : POSITION,
				 out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matProjection);
	otex = itex;//+texeloffset;
	//otex.y = 1.f-itex.y;
}

void vs_guassianf(in float4 ipos : POSITION,
				 in float2 itex : TEXCOORD0,
				 out float4 opos : POSITION,
				 out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matProjection);
	otex = itex;//+texeloffset;
	otex.y = 1.f-itex.y;
}

float4 ps_guassian(in float2 tex : TEXCOORD0) : COLOR0
{
	/* 3x3 NPK kernel*/
	float2 offset = (begin)*factor; 
	float4 p = tex2D(src, tex) + 
			   tex2D(src, float2(tex.x+offset.x, tex.y))+
			   tex2D(src, float2(tex.x-offset.x, tex.y))+
			   tex2D(src, float2(tex.x,          tex.y+offset.y))+
			   tex2D(src, float2(tex.x,          tex.y-offset.y))+
			   
			   tex2D(src, float2(tex.x+offset.x, tex.y+offset.y))+
			   tex2D(src, float2(tex.x+offset.x, tex.y-offset.y))+
			   tex2D(src, float2(tex.x-offset.x, tex.y+offset.y))+
			   tex2D(src, float2(tex.x-offset.x, tex.y-offset.y));
			   p/=9.f;
	return p;
}

float4 ps_guassian_motion(in float2 tex : TEXCOORD0) : COLOR0
{
	/* 3x3 NPK kernel*/
	float2 offset = (begin+texeloffset)*factor; 
	float4 p = tex2D(src, tex+texeloffset) + 
			   tex2D(src, float2(tex.x+offset.x, tex.y))+
			   tex2D(src, float2(tex.x-offset.x, tex.y))+
			   tex2D(src, float2(tex.x,          tex.y+offset.y))+
			   tex2D(src, float2(tex.x,          tex.y-offset.y))+
			   tex2D(src, float2(tex.x+offset.x, tex.y+offset.y))+
			   tex2D(src, float2(tex.x+offset.x, tex.y-offset.y))+
			   tex2D(src, float2(tex.x-offset.x, tex.y+offset.y))+
			   tex2D(src, float2(tex.x-offset.x, tex.y-offset.y));
			   p/=9.f;
	return p*=mfactor;
}

technique guassian
{
	pass standard
	{
		VertexShader = compile vs_2_0 vs_guassian();
		PixelShader  = compile ps_2_0 ps_guassian();
	}
	
	pass motion_blur
	{
		VertexShader = compile vs_2_0 vs_guassian();
		PixelShader  = compile ps_2_0 ps_guassian_motion();
	}
	
	pass flipped
	{
		VertexShader = compile vs_2_0 vs_guassianf();
		PixelShader  = compile ps_2_0 ps_guassian();
	}
}