float4x4 matWorldViewProjection;
float4x4 matWorldView;

void vs_normal(in float4 ipos : POSITION,
			   in float3 inormal : NORMAL,
			   out float4 opos : POSITION,
			   out float3 onormal : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	onormal = normalize(mul(inormal, matWorldView));
};

float4 ps_normal(in float3 normal : TEXCOORD0) : COLOR0
{
	return float4(normal.xyz, 1.f);
};

technique normal 
{
	pass base
	{
		VertexShader = compile vs_2_0 vs_normal();
		PixelShader  = compile ps_2_0 ps_normal();
	}
}