/*base*/
float4x4 matWorldViewProjection;
texture tex1;
float alpha = 1.f; 

sampler2D texture1 =
sampler_state
{
	texture = (tex1);
	MinFilter = Linear; 
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU = Wrap;
	AddressV = Wrap; 
};

/*fog*/
float FogStart = 0.f;
float FogEnd  = 100.f;
float3 CameraPosition = {0.f, 0.f, 0.f};
float4x4 matWorld; 



void vs_texture(in float4 ipos : POSITION,
			   in float2 itex : TEXCOORD0,
			   out float4 opos : POSITION,
			   out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	otex.y = 1.f-itex.y;
}

void vs_texturefog(in float4 ipos : POSITION,
			   in float2 itex : TEXCOORD0,
			   out float4 opos : POSITION,
			   out float2 otex : TEXCOORD0,
			   out float  fog : TEXCOORD1)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	otex.y = 1.f-itex.y;
	
	fog = 1.f-clamp( (length(CameraPosition-mul(ipos, matWorld))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
}

float4 ps_texturefaen(in float2 tex : TEXCOORD0) : COLOR0
{
	//return float4(1.f, 1.f, 1.f, 1.f);
	return tex2D(texture1, tex)*alpha; 
	
}

float4 ps_texture(in float2 tex : TEXCOORD0) : COLOR0
{
	//return float4(1.f, 1.f, 1.f, 1.f);
	return tex2D(texture1, tex); 
	
}

float4 ps_texturefog(in float2 tex : TEXCOORD0,
					 in float  fog : TEXCOORD1) : COLOR0
{
	return tex2D(texture1, tex)*fog; 
}

float4 ps_texturealf(in float2 tex : TEXCOORD0,
					 in float  fog : TEXCOORD1) : COLOR0
{
	float4 p = tex2D(texture1, tex);
	
//	clip(p-.001f);
//	return p; 
	return float4(1.f ,1.f, 1.f, p.r*alpha);//*(p.r-1.f); 
}

technique _texture
{
	pass base
	{
		VertexShader = compile vs_2_0 vs_texture();
		PixelShader  = compile ps_2_0 ps_texture(); 
	}
	
	pass basefog
	{
		VertexShader = compile vs_2_0 vs_texturefog();
		PixelShader  = compile ps_2_0 ps_texturefog(); 
	}
	
	pass basealpha
	{
		VertexShader = compile vs_2_0 vs_texturefog();
		PixelShader  = compile ps_2_0 ps_texturealf(); 
	}
	
	pass alphadude
	{
		VertexShader = compile vs_2_0 vs_texture();
		PixelShader  = compile ps_2_0 ps_texturefaen(); 
	}
}
