attribute vec3 normals;
attribute vec3 tangent;
attribute vec2 texCoord1;
attribute vec2 displace;
varying vec2 texCoords;


varying vec3 varyEyeVec;
varying vec3 varyTangent;
varying vec3 varyBiNormal;
varying vec3 varyNormal;
varying vec3 varyLight;
uniform float toSeed;
uniform float fromSeed;
uniform float seedT;

void main()
{
float seed =fromSeed + (toSeed-fromSeed)*seedT;
vec3 seedS = vec3(seed + displace.x*0.2,seed + displace.x*displace.y*0.1,seed + displace.y*0.1);
float dispExtra = length(displace)*0.001;
vec4 scaledV = vec4(sin(seedS.x)*200.0+600.0,sin(seedS.y)*2600.0+3000.0 + dispExtra,cos(seedS.z)*400.0+600.0,1.0) * gl_Vertex;
vec4 transedV = scaledV + vec4(displace.x,0.0,displace.y,0.0);
//     gl_Position = ftransform();
 gl_Position = gl_ModelViewProjectionMatrix * transedV;
 texCoords = texCoord1; 

 
 varyEyeVec = vec3(gl_ModelViewMatrix*transedV);
 varyNormal = normalize(gl_NormalMatrix*normals);
 varyTangent = normalize(gl_NormalMatrix*tangent);
 varyBiNormal = normalize(cross(varyNormal,varyTangent));
 
 varyLight = -varyEyeVec;
 
 //make eyeVec in tangent space.
 vec3 tempEye = varyEyeVec;
 varyEyeVec.x = dot( tempEye, varyTangent ); 
 varyEyeVec.y = dot( tempEye, varyBiNormal ); 
 varyEyeVec.z = dot( tempEye, varyNormal ); 
 
 vec3 tempLight = varyLight;
 varyLight.x = dot( tempLight, varyTangent ); 
 varyLight.y = dot( tempLight, varyBiNormal ); 
 varyLight.z = dot( tempLight, varyNormal ); 
 
}