attribute vec3 normals;
attribute vec3 tangent;
attribute vec2 texCoord1;
attribute vec3 displace;
varying vec2 texCoords;


varying vec3 varyEyeVec;
varying vec3 varyTangent;
varying vec3 varyBiNormal;
varying vec3 varyNormal;
varying vec3 varyLight;
uniform float blowup;
void main()
{


float dist = length(displace)*0.01;
vec3 blowit = vec3(sin(displace.x +displace.y)*blowup*dist,
     cos(displace.x*3.2 )*0.7*blowup*dist + 0.7*blowup*dist,
     sin(displace.z*0.2)*dist*blowup);

 float rotAngle=blowup*0.04*(sin(displace.x*0.4+displace.y*0.34+displace.z*0.34))*3.9;
 mat4 rotMod;
 rotMod[0]=vec4(cos(rotAngle),sin(rotAngle),0.0,0.0);
 rotMod[1]=vec4(0.0,cos(rotAngle),sin(rotAngle),0.0);
 rotMod[2]=vec4(0.0,-sin(rotAngle),cos(rotAngle),0.0);
 rotMod[3] = vec4(vec3(0.0),1.0);

vec4 transedV = rotMod*gl_Vertex + vec4(displace + blowit,0.0);
//     gl_Position = ftransform();


 gl_Position = gl_ModelViewProjectionMatrix * transedV;
 texCoords = texCoord1; 

 
 varyEyeVec = vec3(gl_ModelViewMatrix*transedV);
 varyNormal = normalize(gl_NormalMatrix*normals);
 varyTangent = normalize(gl_NormalMatrix*tangent);
 varyBiNormal = normalize(cross(varyNormal,varyTangent));
 
 varyLight = -varyEyeVec;
 
 //make eyeVec in tangent space.
 vec3 tempEye = varyEyeVec;
 varyEyeVec.x = dot( tempEye, varyTangent ); 
 varyEyeVec.y = dot( tempEye, varyBiNormal ); 
 varyEyeVec.z = dot( tempEye, varyNormal ); 
 
 vec3 tempLight = varyLight;
 varyLight.x = dot( tempLight, varyTangent ); 
 varyLight.y = dot( tempLight, varyBiNormal ); 
 varyLight.z = dot( tempLight, varyNormal ); 
 
}