attribute vec3 normals;
attribute vec3 tangent;
attribute vec2 texCoord1;

varying vec3 varyEyeVec;
varying vec3 varyNormal;
varying vec3 varyTangent;
varying vec3 varyBiNormal;
varying vec2 texCoords;

void main()
{
 texCoords = texCoord1;
 gl_Position=ftransform();
 varyEyeVec = vec3(gl_ModelViewMatrix*gl_Vertex);
 varyNormal = normalize(gl_NormalMatrix*normals);
 varyTangent = normalize(gl_NormalMatrix*tangent);
 varyBiNormal = normalize(cross(varyNormal,varyTangent));
 
 //make eyeVec in tangent space.
 vec3 tempEye = varyEyeVec;
 varyEyeVec.x = dot( tempEye, varyTangent ); 
 varyEyeVec.y = dot( tempEye, varyBiNormal ); 
 varyEyeVec.z = dot( tempEye, varyNormal ); 
 
}