varying vec2 texCoord;
uniform sampler2D baseMap;
uniform sampler2D noiseMap;
uniform sampler2D skyMap;
uniform samplerCube envMap;
uniform sampler2D reflectMap;

uniform float anim;
varying vec3 norm;
varying vec3 eyeVec;
varying vec3 lightVec;
varying vec3 eyeTex;
void main()
{
vec3 noiseSample = texture2D(noiseMap,vec2(anim*0.03 - texCoord.x*343.1,anim*0.03 + texCoord.y*343.01)).rgb * 2.0 - vec3(1.0,1.0,1.0);
vec3 bumpNorm = norm;
bumpNorm.x+=noiseSample.x*0.3 + sin(anim*0.02 + texCoord.x*0.4 + texCoord.y*0.1)*0.08 + 0.08;
bumpNorm.z+=noiseSample.z*0.3 + cos(anim*0.02 + texCoord.x*0.1 +1.0323 + texCoord.y*0.4)*0.08 + 0.08;
bumpNorm = normalize(bumpNorm);
vec3 lightVec2=normalize(lightVec);
float lightRec = max(dot(bumpNorm,lightVec2),0.2);
float spec = clamp(dot(reflect(normalize(eyeVec),bumpNorm),normalize(-lightVec2)),0.0,1.0);
spec = pow(spec,90.0);
float dist = length(eyeVec)/5000.0;
spec = spec*(1.0/pow(dist,1.3));
vec3 envCol = textureCube(envMap,reflect(normalize(eyeVec),bumpNorm)).rgb;
vec4 col = texture2D(baseMap,vec2(texCoord.x+anim*1.2,texCoord.y+anim*1.3));
vec4 skyRef = texture2D(baseMap,bumpNorm.xz);
envCol = vec3(envCol.r/3.0 + envCol.g/3.0 + envCol.b/3.0);
vec2 tC =vec2(eyeTex.xy/eyeTex.z)*0.5 + vec2(0.5);
tC+=bumpNorm.xz*0.01;
vec4 reflCol = texture2D(reflectMap,vec2(tC.x,tC.y));
gl_FragColor = vec4((envCol) * spec + reflCol.rgb*0.2,0.80);


}