float4x4 matView;
float4x4 matViewProjection;

float  tekstanim = 0.f; // [0=first line - 8=last line]
float  fadetoblack = 1.f;
float2 ParticleSize = {5.f, 5.f};

texture tex0; //diffuse
texture tex1; //alphamask

sampler2D diffuse = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};

sampler2D alphamask = 
sampler_state
{
	texture = (tex1);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear; 
	AddressU = Clamp; AddressV = Clamp; 
};

void vs_partikkel(in float3 ipos : POSITION,
				  in float2 itex : TEXCOORD0,
				  out float4 opos : POSITION,
				  out float2 otex : TEXCOORD0,
				  out float2 otex2 : TEXCOORD1,
				  out float  inter : TEXCOORD2,
				  out float  fog : TEXCOORD3,
				  out float2 texalpha : TEXCOORD4,
				  out float3 texalpha2 : TEXCOORD5)
{
	float xcoord = 1.f/8.f;
	fog = 1.f-clamp((abs(ipos.z)/450.f), 0.f, 1.f);
	
	int del = floor(tekstanim);
	float abase = (1.f-((ipos.y+20.f)/40.f))/8.f;
	texalpha.x = ((ipos.z+500.f)/1000.f)*3.125 - 1.0625f;
	texalpha.y = abase+del*xcoord;
	texalpha2.y = abase+(del+1)*xcoord; 
//	texalpha2 = float3(0.f, 0.f, 0.f);
	texalpha2.x = texalpha.x; 
	texalpha2.z = frac(tekstanim);
	
	float factor = length(ipos.xyz);	
	float dude = ((factor/500.f)*8.f);
	inter = frac(dude);
	int part = floor(dude);
	 
	
	
	ipos += float3(matView._11, matView._21, matView._31)*itex.x*ParticleSize.x;
	ipos += float3(matView._12, matView._22, matView._32)*itex.y*ParticleSize.y;
	opos = mul(float4(ipos, 1.f), matViewProjection);
	otex = itex + .5f;
	otex.y = 1.f-otex.y;
	otex2 = otex;
	
	float x = otex.x;
	otex.x = otex.x  * xcoord + (xcoord*part);
	otex2.x = x  * xcoord + (xcoord*(part+1));
}


float4 ps_partikkel(in float2 tex : TEXCOORD0,
					in float2 tex2: TEXCOORD1,
					in float inter : TEXCOORD2,
					in float fog : TEXCOORD3,
					in float2 alphatex : TEXCOORD4,
					in float3 alphatex2 : TEXCOORD5) : COLOR0
{
	float4 a = tex2D(diffuse, tex);
	float4 b = tex2D(diffuse, tex2);
	float4 p = lerp(a, b, inter);
	float4 am = tex2D(alphamask, alphatex);
	float4 am2 = tex2D(alphamask, alphatex2.xy);
	
	float4 af = 1.f-lerp(am, am2, alphatex2.z);
	//return am;
	return p*fadetoblack*af*fog;
}

technique Partikkel
{
	pass diffuse
	{
		VertexShader = compile vs_2_0 vs_partikkel();
		PixelShader  = compile ps_2_0 ps_partikkel();
	}
}