;
;  A "smooth" starfield in <128 bytes.....By Indi
;

		org $2000-2            	; -2 since we have to include a LOAD address
		dw	$2000


SCNCLR		equ	$D880				; ROM clear screen
COLOUR		equ	$053b

Delay		equ	$02
StarAdd		equ	$42
StarChar	equ	$80
CharAdd		equ	$fc
ScreenBase	equ	$ff
CharSet		equ	$7000


		;
		; On plus/4 reset and 1st SYS call.  A=0,X=7,Y=0,F=0  ($07f2-$07f5)
		; SYS command - $a7b5
		;

Start
		;
		; Init star addresses using random ROM values.
		;
		ldx	#$20
!InitAll:
		ldy	$ba88,x				; create stars
		sty	StarAdd,x
		sta	CharSet-1,x			; Clear Charset
		sta	CharSet+$f0,x		; Clear Charset
		sta	$ff0d,x				; Clear at least $ff12,$ff15,$ff19
		dex	
		bne	!InitAll			; Init all 32 stars

		; 10 bytes!
		inx
		stx	CharSet+$08+3		; init star graphic
		stx	CharSet+$10+6
		stx	CharSet+$18+4


						 
		lda	#$08				; Set charscreen
		sta	$ff14
		lda	#$71
		sta	$ff13				; set charmap to $7000
	   	jsr	SCNCLR				; clear screen with WHITE
		sei						; no more kernal goodness




		;
		; Process and render stars - main loop
		;
MainLoop
!lp2	ldx	$ff1d				; Sync as best we can....
		bne	!lp2


		; Small CLS routine - clear STARS only
		txa
!lp1:	jsr	PrintStar			; Clears more than 32 stars... but so what....
		inx
		bpl	!lp1




		;
		; Move STARS....
		;
Tick:
		ldx	#3
Loop:
		dec	Delay,x
		bpl	!DontMoveStar
		txa
		sta	Delay,x					; reset delay  Star 1=delay of 1, Star 2 = 2, Star 3=3
		stx	StarChar
		
		lda	StarIndex-1,x			; Load A and X
		tax
		asl	CharSet,x
		bcc	!NoAdd
		rol CharSet,x



		ldx	#$20
!DoAll:
		txa						; Get star type (0,1,2 or 3)
		and	#3					
		cmp	StarChar			; Is this star the one that needs moved?
		bne	!SkipDec
		dec	StarAdd,x			; move star
!SkipDec:
		dex						; Check all star objects
		bne	!DoAll


!NoAdd:	
		ldx	StarChar
!DontMoveStar:
		dex
		bne	Loop



		;
		; Render stars....
		;
		
		ldx #$20
!RenderStars:
		txa						; get star to use
		and	#$03
		jsr	PrintStar
		dex
		bne	!RenderStars		; Do all 32 stars
		beq	MainLoop


		;
		; Print a star OR a space to wipe
		;
PrintStar:		
		ldy	StarAdd,x			; get location
cls
		sta	$0c00,y				;
		sta	$0d00,y				; Print to each region
		sta	$0e00,y				;
		sta	$0f00,y				;
		rts

StarIndex	db	8+3,$10+6,$18+4

EndCode:
	Message "EndSize=",(EndCode-Start)



