
 ; * TechnoMaker - an entry for the limiTED 128-Byte competition
 ; * coded by Ninja / The Dreams in 2007 (while being in Japan :))
 ; * to assemble use AS1.41 or later (or convert it yourself)

 ; ----------------------------------------ninja@the-dreams.de---

              cpu 6502undoc
              page 0
hi            function x,(x>>8)&255
lo            function x,x&255


width         = 16               ; bitmap width
height        = 7                ; bitmap height
y_stretch     = $16              ; height stretch factor

delay_valx    = 13               ; magic numbers for the outer delay loop
delay_valy    = 245              ; brute-force caclulated using following basic-program

 ; cycles = 17396
 ; m = cycles
 ;
 ; for y=0 to 255
 ;  for x=0 to 255
 ;   v = cycles - ((x*5+6)*y+1)
 ;   if (v>=0) and (v=<m) then
 ;     m=v: mx=x: my=y:
 ;     if m<100 then ?"Missing cycles:";m,"delay_xval:";mx,"delay_yval:";my
 ;   end if
 ;  next x
 ; next y

speedcode_hi  = $80 - height     ; speedcode from $xx00 - $7f00
maincode_hi   = $10              ; this code at $10xx


 ; these labels look a bit complicated. They are needed this way,
 ; because the SYS-command sets some zeropage to desired values, so
 ; simple bpl-branches can be used throughout the code.
drawline      = speedcode_hi * $100 + maincode_hi + $80 - width*3
maincode      = maincode_hi * $100 + speedcode_hi - (width/8) * height

zp_02          = $22         ; = $02
sc_pnt         = $64         ; = speedcode_hi * $100 + maincode_hi
                             ; all set via SYS
pio_keyboard  = $fd30
ted_ctrl1     = $ff06
ted_keylatch  = $ff08
ted_snd1frqlo = $ff0e
ted_snd2frqlo = $ff0f
ted_sndctrl   = $ff11
ted_bordercol = $ff19

              org maincode

bitmap:
              binclude "limited.dat"      ; bitmap data, size is (width/8) * height

sys_value:
              sei                         ; do not disturb :)
              ;ldx #0                     ; assuming a resetted machine, x is already 0
              stx pio_keyboard            ; allow all keys

 ; speedcode-generator, needs x=0

sc_l2:
              ldy #$80-width*3
sc_l1:
              asl bitmap+height,x
              rol bitmap,x                ; get bit from bitmap
              lda #$2c                    ; BIT-opcode when same color
                                          ; (because of TED's light gray pixel bug)
              bcc no_change
              sta ted_ctrl1               ; disable screen (weird place to do this ;))
              jsr $a62b
              adc #$8e-1                  ; toggle between STA and STX
no_change:
              sta (sc_pnt),y
              iny
              lda #lo(ted_bordercol)
              sta (sc_pnt),y
              iny
              lda #hi(ted_bordercol)
              sta (sc_pnt),y
              iny                         ; whole width reached?
              bpl sc_l1
              lda #$60
              sta (sc_pnt),y
              inx
              inc sc_pnt+1
              bpl sc_l2                   ; next page, until bitmap is done

 ; main loop: accu = current rastercolor
 ; every loop inside here needs a fixed amount of cycles. It looks a bit
 ; messy because of this.

draw_l3:
              ldy #hi(drawline)
              sty draw_mod+2
draw_l2:
              ldx zp_02                   ; = ldx #2, wasting a cycle
              ldy #y_stretch
draw_l1:
              dex
              bne *-1                     ; inner delay loop (wait for next rasterline)
              adc #$10                    ; next luminance and/or next color
draw_mod:     jsr drawline                ; draw currrent rasterline
              ldx #5
              dey
              bne draw_l1                 ; stretch factor done?
              ldy #delay_valy             ; y is set here to waste cycles
              inc draw_mod+2
              bpl draw_l2                 ; whole bitmap displayed?

              adc #lo(-height*y_stretch)  ; adjust color for rasterbar-scrolling
              php                         ; save accu and carry
              tax                         ; otherwise scrolling will jump!
              lsr
              lsr
              sta ted_snd2frqlo           ; abuse this value for music
              sta ted_sndctrl             ; squarewave fun! :)
              sta ted_keylatch
              eor ted_keylatch
              eor #$ff                    ; invert keylatch (%1=pressed)
              sta ted_snd1frqlo           ; abuse keyboard interaction
              txa
              plp
wait_l1:
              ldx #delay_valx             ; outer delay loop (y was set above)
              dex                         ; next display will be 2 lines down and 1 char right
              bne *-1
              dey
              bne wait_l1
              beq draw_l3                 ; endless loop. Done! Hooray!


           if 0

 ; this routine converts a single 2x1-char into the bitmap-format
 ; needed by the code-generator (%0 = no change, %1 = change color).

              align 256

dupe          = $02

              sei
              ldx #0
              stx dupe
dupe_l2:
              ldy #15
dupe_l1:
              asl $2200,x
              rol $2000,x
              lda #0
              rol
              cmp dupe
              sta dupe
              bne dupe_found
              clc
              byt $24
dupe_found:
              sec
              rol result+height,x
              rol result,x
              dey
              bpl dupe_l1
              inx
              cpx #height
              bcc dupe_l2
              cli
              rts

              align 128
result        = *

           endif

              end maincode
