;
; 6fx
; 1024 byte demo
;
; Written by Csabo of LOD 2007
; Code is very heavily optimized for space
;
; Features:
;   - screen wiped away and faded
;   - music (base, lead, drums) that increases in tempo
;   - oldschool rasters
;   - petscii plasma
;   - plotter
;   - chessboard zoom
;   - kefrens
;   - digiplayer
;
	ORG $1010-2
	DW  $1010
	;
notecount	= $7D		; assumed to be 7
notelen		= $72		; assumed to be 1
basecount	= $C2		; assumed to be 0
restart_counter	= $23		; assumed to be 2
timer		= $D0		; assumed to be 0
;
drum_ctrl_1	= $9F		; assumed to be 8
;
fill_ptr	= $F0		; 16 bit, low byte assumed to be 0
fill_cnt	= $F2		; any zeropage variable
;
player_ptr	= $3B		; fixed, player reads byte to here
get_next_byte	= $0473		; gets one byte and increments pointer
	;
	include "sinusgen.asm"
	;
	; *** Player init
	;
	ROR player_ptr+1	; carry is SET! change player pointer to anywhere above $8000
	;
	DEC $047B  		; change $FF3F to $FF3E, so it reads from ROM
	;
	include "wipeaway.asm"
	;
restart
	INC $FF16		; keep changing colors for kefrens :-)
	;
	LDY #$08
	STY $FF07		; only needed because of restart
	DEY
	STY $FF12		; set sound channel 2's high bit to $03 (high notes)
	;
	include "rasters.asm"	; main parts in order, continuous code
	include "plasma.asm"
	include "plotter.asm"
	include "zoom.asm"
	include "kefrens.asm"
	;    
	LDA #$D1
	STA $FF13
	;
;	LDA lead_ptr+1		; this switched between two set of lead notes
;	CMP #(lead2-1 & 255)	; removed, not enough space
;	BEQ digi
;	;
;	LDA #(lead2-1 & 255)
;	STA lead_ptr+1
	;
	LSR drum_ctrl_1		; drum control: beat gets faster
	LSR drum_ctrl_2+1
	;
	INC raster_col_ptr+1	; change raster effect: different colors
	;
	LDA plot_fx_control	; change plot effect
	EOR #$E0		; alternates between NOP ($EA) and ASL ($0A) opcodes
	STA plot_fx_control
	;
	DEC restart_counter	; assumed to start from 2, so restarts twice
	BMI digi
	JMP restart
	;   
digi
	include "digi.asm"
	;
calc_pos			; lifted out from qplot
	TXA			; INPUT: X = plot number
	ASL a			; calculates the position of the plot
	ADC x_sin		; and sets the address to "dest"
	TAY
	LDA sinus,y
	AND #$3F
	STA dest
	;
	TXA
plot_fx_control
	ASL a			; self-mod: alternates between ASL and NOP
	ADC y_sin
	TAY
	LDA sinus,y
	TAY			; save bit value for later
	LSR a
	LSR a
	LSR a
	AND #$07
	ORA #$68
	STA dest+1
	;
	TYA			; reload bit value
	AND #$07      
	TAY
	LDA $C289,y		; look up graphics from ROM
	LDY #$00		; pre-load Y
	;
	RTS
	
clear_screen_sync
	LDY #$FF
	JSR sync
	;
	ROR $FF06		; screen off
	;	
clear_screen
	STX $FF15
	STX $FF19
	;
	JMP $D880
	
clear_6800_6900
	LDA #$00		; clear out charset for ff1d, or colors for raster
	TAY
c68	STA $6800,y
	STA $6900,y
	INY
	BNE c68
	RTS
	;
	; *** A sync'ed fill routine
	;                             
erase_charset
	LDA #$00
	LDX #$07
fill_68	LDY #$68
	;
	; parameters: A = fill byte
	;             X = number of pages
	;             Y = high byte of address
fill	; 		
	STY fill_ptr+1
	STX fill_cnt
	;
fill2	PHA			; entry point to "continue" filling
	JSR player_sync		; player uses A,X,Y
	PLA
	;
	LDY #$00		; so must reset Y each time
fill1	STA (fill_ptr),y
	INY
	BNE fill1
	;
	INC fill_ptr+1
	;
	DEC fill_cnt		; count down the pages
	BPL fill2
	;
	RTS
	
sync_2x	JSR sync
	DEY
	DB $2C
sync_DC	LDY #$DC
sync	CPY $FF1D
	BNE sync
	RTS
	;
close_border
	LDA #$CA
	STA $FF1D
	;
player_sync
	JSR sync_DC
	;
	include "player.asm"
	;
data_raster_col = $E081 	; get colors from ROM
data_raster_col_size = 12
	;DB $4,$B,$2,$8,$9,$7,$A,$5,$C,$3,$6,$D
	
data_raster_lum = $E3BB		; get rasterbar from ROM
data_raster_lum_size = 10
	;DB $10,$30,$50,$60,$70,$60,$50,$30,$10

data_raster_chars
	;DB $48,$20
	DB $47,$6A,$6A,$48,$C7,$F4,$F4,$C7,$A0,$E5,$A0
	DB $A0,$EA,$A0,$C8,$EA,$EA,$C8,$47,$74,$74,$48
	;DB $20,$47
data_raster_chars_end
	
ora_init			; kefrens graphics
	DB $D9,$C0,$36,$70
	DB $0D,$9C,$03
	;DB $67			; this byte shared by the digi table
	
bass	= $1053
bass2	= $1067
noise1	= $10AD
noise2	= $1042
snare2	= $1033

bas0	= bass & 255
bas2	= bass2 & 255
noi1	= noise1 & 255
noi2	= noise2 & 255
snr2	= snare2 & 255
	;
	; the beat
	;
beat	DB bas2,noi1,bas0,noi2,bas2,noi1,bas0,noi1
	DB bas2,noi1,bas0,noi2,bas2,snr2,bas0,snr2

plasma_chars			; plasma characters (must not end up on page boundary)
	DB $3A,$2E,$2C,$3B,$64,$2F,$28,$3C
	DB $09,$14,$25,$24,$2A,$18,$38,$41
;[eof]