;**********************
;* SCROLLOMATIC
;* 1k demo by
;* Rachy/MX
;* (c) 2007
;*
;* Submitted to
;* [limiTED] compo
;*
;* Compile it with
;* A6 assembler:
;*   a6 -fp -s2 -t scrollomatic.asm
;*
;* Runs on C= Plus/4
;**********************

ptr1		=	$e0
ptr2		=	$e2
spacecount	=	$e4

scrollpos	=	$d0
scrollbuf	=	$d1
indent		=	$d2
chrbuf		=	$d4
chrintcount	=	$d6
screenpos	=	$0D68
lineend		=	screenpos+39
conv		=	$6000

;cheating! this memory space must contain zero values after start
tmpbuf		=	$f0

.org	$1001
.byte	$0a,$10,$D7,$07,$9E,$34,$31
.byte	$30,$39
.byte	$00,$00,$00

*=$100d
	sei
	lda $ff19
	sta borderc+1
	lda $ff15
	sta bgc+1
	lda #<irq1
	sta $0314
	lda #>irq1
	sta $0315
	jsr restart
	ldx #0
	stx chrintcount
	stx spacecount
	stx indent
colorcyc
	lda #$76
	sta screenpos-$400,x
	inx
	cpx #200
	bne colorcyc

;Depack charset
	lda #<charset
	sta ptr1
	lda #>charset
	sta ptr1+1
	lda #>conv
	sta ptr2+1
	ldy #$0
	ldx #$0
	stx ptr2
cycd
	lda (ptr1,x)
	pha
	lsr
	lsr
	lsr
	lsr
	sta (ptr2),y
	pla
	and #$0f
	iny
	sta (ptr2),y
	iny
	bne contd
	inc ptr2+1
	lda ptr2+1
	cmp #>conv+$400
	beq endd
contd
	inc ptr1
	bne cycd
	inc ptr1+1
	bne cycd
endd
	cli
	jmp *

irq1
	asl $ff09
bgcolor	= *+1
	lda #$00
	sta $ff19
	sta $ff15
	lda indent
	sta $ff07

	lda #$70
	ldx #<irq2
	ldy #>irq2
	bne irqend

irq2
	asl $ff09
borderc	lda #$00
	sta $ff19
bgc	lda #$00
	sta $ff15
	lda #$08
	sta $ff07
	jsr doscroll

	lda #$4e
	ldx #<irq1
	ldy #>irq1
irqend
	sty $0315
	stx $0314
	sta $ff0b
	jmp $fcbe

doscroll
	lda indent
	beq mustscroll
	dec indent
	rts

new	lda scrollbuf
	ldx #$01	;slim width char
	cmp #$09	;Char: I
	beq putwidth
	cmp #$2e	;Char: .
	beq putwidth
;	cmp #$2c	;Char: , - removed for gaining some free bytes
;	beq putwidth
;	cmp #$21	;Char: ! - removed for gaining some free bytes
;	beq putwidth
	ldx #$02	;else: normal witdh char
putwidth
	stx chrintcount

	sta chrbuf
	lda #$00
	asl chrbuf
	rol
	asl chrbuf
	rol
	asl chrbuf
	rol
	asl chrbuf
	rol
	sta chrbuf+1
	lda chrbuf
	sec
	sbc scrollbuf
	sta chrbuf
	lda chrbuf+1
	sbc #$00
	clc
	adc #>conv
	sta chrbuf+1
	ldy #$00

orc	lda (chrbuf),y
	ora tmpbuf,y
	sta tmpbuf,y
	iny
	cpy #$10
	bne orc
	rts

mustscroll
	lda #$07
	sta indent
	ldx #$00
chrcopy
	lda screenpos+1,x
	sta screenpos,x
	inx
	cpx #$C8
	bne chrcopy
	lda chrintcount
	bne skipchar
putchr
	lda spacecount		;is there space in the buffer?
	beq readchr		;no -> read new char

	dec spacecount
	lda #$20
	bne newchar
	
readchr
	ldy scrollpos
	inc scrollpos

chr	lda scrolltxt,y
	bpl newchar
;control char
	eor #$80
	bne spacetobuf

	jsr restart	;it was $80 -> restarting scroll
	bpl readchr
spacetobuf
	cmp #$20	;>$20 - setcolor command
	bcs setcolor
	sta spacecount
	bne putchr

setcolor
	eor #$20
	sta bgcolor
	bpl readchr

newchar
	sta scrollbuf
	jsr new
skipchar
	dec chrintcount
	ldx #$00
	ldy #$00
	jsr chrconv
	ldx #$03
	ldy #$28
	jsr chrconv
	ldx #$06
	ldy #$50
	jsr chrconv
	ldx #$09
	ldy #$78
	jsr chrconv
	ldx #$0C
	ldy #$A0
	jmp chrconv

chrconv
	txa
	pha
	lda tmpbuf,x
	tax
	lda patterns,x
	sta lineend,y
	pla
	tax
	lda tmpbuf+1,x
	sta tmpbuf,x
	lda tmpbuf+2,x
	sta tmpbuf+1,x
	lda #$00
	sta tmpbuf+2,x
	rts

restart
	lda #$00
	sta scrollpos
	rts

patterns
	.byte $20,$2a,$0d,$6D,$18,$5D,$70,$6B	; 1 = *, 2 = M, 4 = X
	.byte $00,$7D,$40,$71,$6E,$73,$72,$5B

scrolltxt
	.byte $a0
	.tscru "#$ presents:"
	.byte $93,$a6
	.tscru "scrollomatic"
	.byte $93,$ac
	.tscru "this small demonstation was submitted to"
	.byte $84,$a2
	.tscru "( limited )"
	.byte $84,$a6
	.tscru "1k competition."
	.byte $93,$a3
	.tscru "i hope you enjoyed. "
	.byte $93,$fe
	.tscru "scroll restarts..."
	.byte $93,$80	;End

charset
	.incbin "chars_compact.bin"

