;
; Scrolling rainbow - a scrolling rainbow effect in 64 bytes
;
; Written by Csabo of LOD 2007
;
; Uses no zeropage variables, solid timing
; Carfully chosen number of colors + rasterline's height: gives scrolling effect
;
	ORG $100D-2
	DW $100D
	
	SEI		; no interrupts 
	ROL $FF13	; single clock
	ROR $FF06	; screen off
	;
	LDX #$00	; unnecessary, but had 2 bytes left
	;
main	LDY #$0D	; one rasterline's height
	INX		; x is color counter
	;
rloop	CPX #$0B	; placed here as padding
	BNE *+4		; does nothing inside the rloop (raster loop)
	LDX #$00	; but takes care of color increment
	;    
hsync	LDA $FF1E	; horizontal sync to $80! :-)
	BPL hsync	; leaves X, Y alone
	;
	LDA col,X	; load the color code
	ORA lum,Y	; or it with luminance to get final color value 
	;
	STA $FF19	; put it on the border
	DEY		; y loop
	BPL rloop
	BMI main	; restart
	
lum	DB $00,$20,$30,$40,$50,$60,$70		; one rasterbar (14 lines high)
	DB $70,$60,$50,$40,$30,$20,$00
	
col	DB $2,$B,$4,$6,$3,$C,$5,$A,$7,$9,$8	; rainbow colors (11 colors)

						; total rainbow area: 154 lines

;[eof]