
uniform sampler2DShadow shadowMap;
uniform float size; // Assumes width and height of shadowMap is the same
uniform bool usePCF;
uniform float kTransparency;

uniform sampler2D tex1;
uniform sampler2D tex2; // NOT USED
uniform sampler2D tex3; // NOT USED

varying vec3 normal, lightDir, eyeVec;
varying vec4 projCoord;

float offsetLookup(sampler2DShadow map, vec4 loc, vec2 offset)
{
	vec2 texMapScale;
	texMapScale.x = 1.0/size;
	texMapScale.y = 1.0/size;

	return shadow2DProj(map, vec4(loc.xy + offset * texMapScale * loc.w, loc.z, loc.w)).r;
}

void main (void)
{
	float shadow = 0.0;

	if(usePCF)
	{
		// 4x PCF Shadow Mapping
		float x, y;
		for(y = -0.5; y <= 0.5; y += 1.0)
			for(x = -0.5; x <= 0.5; x += 1.0)
				shadow += offsetLookup(shadowMap, projCoord, vec2(x,y));

		shadow = shadow/4.0;

		// 16x PCF Shadow Mapping
	//	float x, y;
	//	for(y = -1.5; y <= 1.5; y += 1.0)
	//		for(x = -1.5; x <= 1.5; x += 1.0)
	//			shadow += offsetLookup(shadowMap, projCoord, vec2(x,y));
	//
	//	shadow = shadow/16.0;
	}
	else
	{
		shadow = shadow2DProj(shadowMap, projCoord).r;
	}

	vec4 texColour = texture2D(tex1, gl_TexCoord[0].st);
	vec4 final_color = (gl_FrontLightModelProduct.sceneColor * gl_FrontMaterial.ambient * texColour)
						+ (gl_LightSource[0].ambient * gl_FrontMaterial.ambient * texColour);

	vec3 N = normalize(normal);
	vec3 L = normalize(lightDir);

	float lambertTerm = dot(N, L);

	if(lambertTerm > 0.0)
	{
		final_color += texColour * gl_LightSource[0].diffuse * gl_FrontMaterial.diffuse *
						lambertTerm * (kTransparency + ((1.0-kTransparency) * shadow));

		//vec3 E = normalize(eyeVec);
		//vec3 R = reflect(-L, N);
		//float specular = pow( max(dot(R, E), 0.0), gl_FrontMaterial.shininess );

		//final_color += gl_LightSource[0].specular * gl_FrontMaterial.specular * specular * shadow;
	}

	gl_FragColor = final_color;
}