
varying vec3 normal, lightDir, eyeVec;

void main()
{	
	normal = gl_NormalMatrix * gl_Normal;
		
	vec3 realPos = vec3(gl_ModelViewMatrix * gl_Vertex);

	// A Directional light's position field is actually it's direction
	lightDir = normalize(vec3(gl_LightSource[0].position));
	
	eyeVec = -realPos;
	
	gl_TexCoord[0] = gl_MultiTexCoord0;
    gl_FrontColor = (gl_FrontLightModelProduct.sceneColor * gl_FrontMaterial.ambient) + (gl_LightSource[0].ambient * gl_FrontMaterial.ambient);
	gl_Position = ftransform();		
}
