

void main(void)
{	
	vec3 normal = normalize(gl_NormalMatrix * gl_Normal);
	// A Directional light's position field is actually it's direction
	vec3 lightDir = normalize(vec3(gl_LightSource[0].position));

	float NdotL = max(dot(normal, lightDir), 0.0);
	
	vec4 globalAmbient = gl_LightModel.ambient * gl_FrontMaterial.ambient;
	vec4 diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	vec4 ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	vec4 specular = vec4(0.0);
	
	if(NdotL > 0.0)
	{
		float NdotHV = max(dot(normal, normalize(gl_LightSource[0].halfVector.xyz)), 0.0);
		specular = gl_FrontMaterial.specular * gl_LightSource[0].specular * pow(NdotHV, gl_FrontMaterial.shininess);		
	}
	
    gl_TexCoord[0] = gl_MultiTexCoord0;
    //Can you do texture in vert shader? it seems to work for the crates etc... but not terrain
	gl_FrontColor = globalAmbient + (NdotL * diffuse) + ambient + specular;
	gl_Position = ftransform();
}