

void main(void)
{
	vec4 realPos = gl_ModelViewMatrix * gl_Vertex;	
	vec3 normal = normalize(gl_NormalMatrix * gl_Normal);
	vec3 lightDir = normalize(gl_LightSource[0].position.xyz - realPos.xyz);

	float NdotL = max(dot(normal, lightDir), 0.0);
	
	vec4 globalAmbient = gl_LightModel.ambient * gl_FrontMaterial.ambient;
	vec4 diffuse = gl_FrontMaterial.diffuse * gl_LightSource[0].diffuse;
	vec4 ambient = gl_FrontMaterial.ambient * gl_LightSource[0].ambient;
	vec4 specular = {0.0, 0.0, 0.0, 0.0};
	
	if(NdotL > 0.0)
	{
		vec3 E = normalize(-(realPos.xyz));
		vec3 R = reflect(-lightDir, normal);
		float specularAmt = pow( max(dot(R, E), 0.0), gl_FrontMaterial.shininess );
		specular = gl_LightSource[0].specular * gl_FrontMaterial.specular * specularAmt;
	}
	
	gl_FrontColor = globalAmbient + (NdotL * diffuse) + ambient + specular;
	gl_Position = ftransform();
}
