
uniform sampler2D renderedToTexture;
uniform sampler2D noiseMap;
uniform sampler2D colourMap;
uniform float timer;

varying vec3 normal, lightDir, eyeVec;
varying vec4 projCoord;
varying float transparency;

void main()
{
	vec2 displacement = gl_TexCoord[0].st;
	float scaledTimer = timer * 0.25;
	
	//displacement.x += scaledTimer;
	displacement.y -= scaledTimer;
	
	vec3 noiseVec = normalize(texture2D(noiseMap, displacement.xy).xyz);
	noiseVec = (noiseVec * 2.0 - 0.9) * 0.8;
	
	vec4 finalColour = texture2DProj(renderedToTexture, projCoord + vec4(noiseVec, 0.0));
	//gl_FragColor = vec4(finalColour.rgb, transparency);
	
	vec4 colour = texture2D(colourMap, gl_TexCoord[0].st + noiseVec.st);
	gl_FragColor = vec4(mix(colour, finalColour, 0.9).rgb, transparency);
	//gl_FragColor = colour;
}