#include "../include/zf.h"

#define SHIELD_ROTATE 2.0f
#define DAMAGE_INTERVAL 100

static int age;
static float rotate;
static int lifespan;
static bool activated;

static void
shield_step(void)
{
    age++;
    rotate += SHIELD_ROTATE;
    if(age >= lifespan)
	activated = false;
}

void
zf_shield_render(void)
{
    float t;
    CLvertex position;
    if(activated) 
    {
	shield_step();
	
	zf_ship_query_position(&position);
	glPushAttrib(GL_ALL_ATTRIB_BITS);

	glDisable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_DEPTH_TEST);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	t = 1.0f - (float)age/lifespan;

	glColor4f(0.2f, 
		  0.5f + 0.3f * t,
		  0.8f + 0.2f * t,
		  t);
	
	/*glColor3f(0.0f, 0.5f*t, 0.5f*t);*/
	glPushMatrix();
	glTranslatef(position.x,
		     position.y,
		     position.z);
	glRotatef(rotate, 0.0f, 1.0f, 0.0f);

	glutWireSphere(0.3f, 8, 8); /*HACKED to fit ship */

	glPopMatrix();

	glPopAttrib();
    }
}

void
zf_shield_init(void)
{
    age = 0;
    rotate = 0.0f;
    lifespan = DAMAGE_INTERVAL;
    activated = false;
}

void
zf_shield_close(void)
{
    /* nothing atm - texture later? */
}

bool
zf_shield_activate(int lfspn)
{
    if(!activated && !zf_ship_query_end_state())
    {
	age = 0;
	lifespan = lfspn;
	activated = true;
	return true;
    }
    return false;
}

void
zf_shield_deactivate(void)
{
    activated = false;
}
