uniform sampler2D tex;
uniform float line, width;

void main()
{
	vec2 coord = gl_TexCoord[0].xy;
	
	gl_FragColor = texture2D(tex, gl_TexCoord[0].xy)
		* smoothstep(line + width * 2.0, line + width, coord.y);
	
	if (coord.y < line - width * 2.0 || coord.y > line + width * 2.0)
	{
		gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
	} else if ( abs(coord.y - line) < width)
	{
		gl_FragColor = texture2D(tex, gl_TexCoord[0].xy);
	} else if (coord.y < line)
	{
		gl_FragColor = texture2D(tex, gl_TexCoord[0].xy)
			* smoothstep(line - width * 2.0, line - width, coord.y);
	}
}
