#include "globals.h"
extern StreamFFT fft;

void Scene2(float time);
void Scene2Max(float time, float ptime);
void Scene2Simple(float time);
void Scene1Simple(float time);
void Scene2End(float time);
void Scene01(float time)
{
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	device->BeginScene();

	//set camera
	float ctime =  1.4f+.1f*sinf(time);//time*.2f;
	camera.SetCamera(D3DXVECTOR3(600.f*sinf(ctime), 0.f, 600.f*cosf(ctime)), 
					 D3DXVECTOR3(0.f, 0.f, 0.f), D3DX_PI/4.5f);

	//set particles

	float increase = 1.f;
	if(time>30.3f)    increase = (time-29.3f);
	if(increase>20.f) increase = 20.f;

	for(int i=0;i<Flow.particleNumber;i++)
		Flow.particleBuffer[i].pos = D3DXVECTOR3(PerlinNoise(i*62345.f) * (10.f*increase), 
												 PerlinNoise(i*234534.f)* (20.f*increase), 
												Wrap((time*200.f+i)*abs(PerlinNoise(i)+.2f), 0.f, 1000.f)-500.f);

		HIVCullModeZ(D3DCULL_NONE, false);
		HIVAlpha(true, D3DBLENDOP_ADD, D3DBLEND_ONE, D3DBLEND_ONE);

	Effects.SetRef("particle01");
	Effects.Get()->SetMatrix("matView", &camera.GetViewMatrix());
	Effects.Get()->SetMatrix("matViewProjection", &camera.GetViewProjectionMatrix());
	Effects.Get()->SetTexture("tex0", Textures.Get("flow01"));
	Effects.Get()->SetTexture("tex1", Textures.Get("keyalpha01"));
	
	Effects.Get()->SetFloat("fadetoblack", Clamp(time*.3f, 0.f, 1.f));
	Effects.Get()->SetFloat("tekstanim", (time*.3f)-1.f);

	printf("time = %f\n", time);
	//printf("time=%f\n", time);
	Effects.BeginEffect(0);
	Flow.RenderParticleStream();
	Effects.EndEffect();

	device->EndScene();
	device->Present(0, 0, 0 ,0);
	return;
};

/******************************************************************************/
/*
10x10 randomised
cosineinterpolate up to 40x40
	- horisontal pass
	- vertical pass
lookup normal - position (interpolate) 
*/

float dynbuffer[GBSIZE*GBSIZE];


void Precalc1(float a=0)
{
	//a=0;
	int seed = 334;
	float help = 0.f;

	float dpi = D3DX_PI/GBSIZE;
	for(int x=0;x<GBSIZE;x++)
	{
		help = 30.f*sinf( x*dpi );
	
		for(int y=0;y<GBSIZE;y++)
		{
			int node = (x*GBSIZE)+y;
			
			float fx = x+a;
			float resolution = 8.f/GBSIZE; //samplevalue
			float noiseparamA = (int)(resolution*(y))+ ((int)((resolution*fx))*GBSIZE);
			float noiseparamB = (int)(resolution*(y)+1)+ ((int)((resolution*fx))*GBSIZE);
			float noiseparamC = (int)(resolution*(y))+ ((int)((resolution*fx)+1)*GBSIZE);
			float noiseparamD = (int)(resolution*(y)+1)+ ((int)((resolution*fx)+1)*GBSIZE);		

			float noisevalA = PerlinNoise(seed*noiseparamA);
			float noisevalB = PerlinNoise(seed*noiseparamB);
			float noisevalC = PerlinNoise(seed*noiseparamC);
			float noisevalD = PerlinNoise(seed*noiseparamD);

			float distanceAB = (resolution*y) - floor(resolution*y);
			float distanceAC = (resolution*fx) - floor(resolution*fx);

			float A = CosineInterpolate(noisevalA, noisevalB, distanceAB);
			float B = CosineInterpolate(noisevalC, noisevalD, distanceAB);

			dynbuffer[node] = CosineInterpolate(A, B, distanceAC);
			dynbuffer[node] *= 8.f;//1.f+3.f*sinf(x*.3f);
			dynbuffer[node] -= help;
			
			dynbuffer[node] -=  30.f*sinf( y*dpi );
			//dynbuffer[node] -= 20.f*sinf( y*dpi );
		}
	}
};

void Precalc2(float a=0, float time=0.f)
{
	//a=0;
	int seed = 334;
	float help = 0.f;
float sync = fft.Gain(3.1f, .05f, time);
	float dpi = D3DX_PI/GBSIZE;
	for(int x=0;x<GBSIZE;x++)
	{
		help = 30.f*sinf( x*dpi );
	
		for(int y=0;y<GBSIZE;y++)
		{
			int node = (x*GBSIZE)+y;
			
			float fx = x+a;
		//	float resolution = 20.f/GBSIZE; //samplevalue

			float resolution = 20.f/GBSIZE; //samplevalue
			float noiseparamA = (int)(resolution*(y))+ ((int)((resolution*fx))*GBSIZE);
			float noiseparamB = (int)(resolution*(y)+1)+ ((int)((resolution*fx))*GBSIZE);
			float noiseparamC = (int)(resolution*(y))+ ((int)((resolution*fx)+1)*GBSIZE);
			float noiseparamD = (int)(resolution*(y)+1)+ ((int)((resolution*fx)+1)*GBSIZE);		

			float noisevalA = PerlinNoise(seed*noiseparamA);
			float noisevalB = PerlinNoise(seed*noiseparamB);
			float noisevalC = PerlinNoise(seed*noiseparamC);
			float noisevalD = PerlinNoise(seed*noiseparamD);

			float distanceAB = (resolution*y) - floor(resolution*y);
			float distanceAC = (resolution*fx) - floor(resolution*fx);

			float A = CosineInterpolate(noisevalA, noisevalB, distanceAB);
			float B = CosineInterpolate(noisevalC, noisevalD, distanceAB);

			dynbuffer[node] = CosineInterpolate(A, B, distanceAC);
			dynbuffer[node] *= (2.f+2.f*sync);//1.f+3.f*sinf(x*.3f);
			dynbuffer[node] -= help;
			
			dynbuffer[node] -=  30.f*sinf( y*dpi );
			//dynbuffer[node] -= 20.f*sinf( y*dpi );
		}
	}
};

void ProduceGround(Mesh *m, float param)
{
	Precalc1(param*10.f*GBSPEED);
	float offset = 100.f/GBSIZE;
	for(int i=0;i<m->NumberOfVertices;i++)
	{
		//m->DoubleBuffer[i].positionCoords.z =  precalc1[i]; 
		m->DoubleBuffer[i].positionCoords.z =  dynbuffer[i]; 

		//Get normals
		D3DXVECTOR3 a = D3DXVECTOR3(0.f, offset, dynbuffer[i+GBSIZE]-dynbuffer[i]);
		D3DXVECTOR3 b = D3DXVECTOR3(offset, 0.f, dynbuffer[i+1]-dynbuffer[i]);
		//float c = dynbuffer[i+100];

		D3DXVec3Cross(&m->DoubleBuffer[i].normal, &a, &b);
		m->DoubleBuffer[i].textureCoords.y = m->TrippelBuffer[i].textureCoords.y;// +  param*-.05f;
	}
};

void ProduceGround2(Mesh *m, float param, float time)
{
	Precalc2(param*10.f*GBSPEED, time);
	float offset = 100.f/GBSIZE;
	for(int i=0;i<m->NumberOfVertices;i++)
	{
		//m->DoubleBuffer[i].positionCoords.z =  precalc1[i]; 
		m->DoubleBuffer[i].positionCoords.z =  dynbuffer[i]; 

		//Get normals
		D3DXVECTOR3 a = D3DXVECTOR3(0.f, offset, dynbuffer[i+GBSIZE]-dynbuffer[i]);
		D3DXVECTOR3 b = D3DXVECTOR3(offset, 0.f, dynbuffer[i+1]-dynbuffer[i]);
		//float c = dynbuffer[i+100];

		D3DXVec3Cross(&m->DoubleBuffer[i].normal, &a, &b);
		m->DoubleBuffer[i].textureCoords.y = m->TrippelBuffer[i].textureCoords.y;// +  param*-.05f;
	}
};

void SceneBlack()
{
	device->BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	device->EndScene();
	device->Present(0,0,0,0);
};

void Scene01(float time, float ptime)
{
	/***BackBuffer Rendring *****************************************************************************************************/
	device->BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);

	/***Sky**********************************************************************************************************************/

	skycamera.SetCamera(D3DXVECTOR3(-40.f, 10.f, 0.f), D3DXVECTOR3(0.f, 25.f, 0.f), D3DX_PI/2.8f);
	HIVCullModeZ(D3DCULL_CCW, false);
	HIVAlpha(true);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", & (HIVMatrixComplete(&D3DXVECTOR3(-00.f, -180.f, -00.f), &D3DXVECTOR3(time*.4f, 0.f, 0.f), 2.f)*skycamera.GetViewProjectionMatrix()));
	Effects.Get()->SetTexture("tex0", Textures.Get("colormap"));
	Effects.Get()->SetFloat("alpha", Clamp(ptime*.2f, 0.f, .8f));
	Effects.BeginEffect(1);
	Meshes.Get("hemi")->RenderMesh();
	Effects.EndEffect();

	/***Lines*****************************************************/

	camera.SetCamera(D3DXVECTOR3(-20.f+10.f*sinf(time*.1f), 45.f, -70.f), D3DXVECTOR3(00.f, 54.f, 00.f), D3DX_PI/3.2f);
	float x = -200.f;
		x = Wrap((time-5.f)*50.f, 0.f, 300.f)-150.f;
	MakeCurvedLine(&meshLine, 20.f, 10.f, time*50.f, 100, 24234, false);

	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, true);
	Effects.SetRef("Line");
	Effects.Get()->SetTexture("tex0", Textures.Get("line"));
	Effects.Get()->SetMatrix("matWorldViewProjection", &camera.GetWVPMatrix(&HIVMatrixComplete(x, 50.f, -57.f, D3DX_PI/2.f, D3DX_PI/2.f, 0.f, 1.f)));
	Effects.BeginEffect(0);
	meshLine.RenderMesh();
	Effects.EndEffect();
	device->EndScene();

	FullScreenBuffer.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x00, 1.f, 0); //0xe43636
	Effects.SetRef("Line");
	Effects.Get()->SetTexture("tex0", Textures.Get("line"));
	Effects.Get()->SetMatrix("matWorldViewProjection", &camera.GetWVPMatrix(&HIVMatrixComplete(x, 50.f, -57.f, D3DX_PI/2.f, D3DX_PI/2.f, 0.f, 1.f)));
	Effects.BeginEffect(1);
	meshLine.RenderMesh();
	Effects.EndEffect();
	FullScreenBuffer.EndScene();

	FullScreenBuffer2.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	Scene2Simple(time);
	FullScreenBuffer2.EndScene();

	device->BeginScene();
	HIVAlpha(true);//
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("fullscreen");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", FullScreenBuffer2.Texture);
	Effects.Get()->SetTexture("tex1", FullScreenBuffer.Texture);
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();

	/***Outline fx*************************************************************************************************************/
/*
	device->EndScene();

	float val = fft.Pure(3, time)/50.f;
	float away = 1.f;
	if(time>72.42f)
		away += (72.42f-time)*.8f;

	ProduceGround(&GroundPlane, time); //.5f
	camera.SetCamera(D3DXVECTOR3(-20.f+10.f*sinf(time*.2f), 45.f, -70.f), D3DXVECTOR3(00.f, 54.f, 00.f), D3DX_PI/3.2f);
	FullScreenBuffer.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	Effects.SetRef("ground1");
	Effects.Get()->SetMatrix("matWorldView", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, 0.f, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), 1.0f)*camera.GetViewMatrix()));
	Effects.Get()->SetMatrix("matLightViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, 0.f, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), 1.0f)*hore.GetViewProjectionMatrix()) );
	Effects.Get()->SetTexture("tex0", Textures.Get("colormap"));
	Effects.Get()->SetTexture("tex1", Textures.Get("fog1"));
	Effects.Get()->SetTexture("tex2", ShadowMap.Texture);
	Effects.Get()->SetFloatArray("LightPosition", light.Position, 3);
	Effects.Get()->SetFloat("TextureSpeed",  time*GBSPEED*-.1f);
		
	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_CW, false);
	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, 0.f, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), (1.f)+((.016f+val)*away))*camera.GetViewProjectionMatrix()));
	Effects.BeginEffect(2);
	GroundPlane.RenderMeshDoubleBuffer();
	Effects.EndEffect();

	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, 0.f, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), 1.00f)*camera.GetViewProjectionMatrix()));
	Effects.BeginEffect(1);
	GroundPlane.RenderMesh();
	Effects.EndEffect();
	FullScreenBuffer.EndScene();


	device->BeginScene();

	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", FullScreenBuffer.Texture);
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();


*/
	/***normal piss************************************************************************************************************/
	device->EndScene();
	FloatMap.BeginScene();

	device->Clear(0, NULL,D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0xffffffff, 1.f, 0);

	float mtime = D3DX_PI/2.f;
	camera.SetCamera(D3DXVECTOR3(-200.f*sinf(mtime), 45.f, -200.f*cosf(mtime)), D3DXVECTOR3(00.f, 0.f, 00.f), D3DX_PI/3.2f);
	
	D3DXVECTOR3 cm =  camera.Target-camera.Position;
	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_CCW, true);
	Effects.SetRef("normal");
	Effects.Get()->SetTexture("tex0", CubeMaps.Get("cubemap"));
	Effects.Get()->SetFloatArray("camera", cm, 3);
	
	Effects.BeginEffect(0);
	
	float sync = -1.f;//pow(fft.Gain(3.1f, .01f, time)+1.f, 2);
	float canim = time*.1f;
	for(int i=0;i<40.f;i++)
	{
		float seed = PerlinNoise(i*i*61324*i);
		D3DXVECTOR3 pos = D3DXVECTOR3(40.f + (seed*60.f)*cosf(i+(time*seed)+(seed*523144.f)), 
			60.f+(seed*60.f)*sinf(i+(time*seed)+(seed*72435.f))-50.f, 
			10.f+(seed*60.f)*sinf(cosf(i)+(time*seed)+(seed*7241234135.f)));

		float s =  (abs(sinf(seed+time))+2.f) *cosf(time+(seed*624.f));
		s = Clamp(s, 0.f, 3.f);

		s*=sync;

		D3DXVECTOR3 rot = D3DXVECTOR3(0.f, 0.f, 0.f);
		Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&pos, &rot,s )*camera.GetViewProjectionMatrix()));
		rot.x -= (D3DX_PI/2.f);
		Effects.Get()->SetMatrix("matWorldView", &(HIVMatrixComplete(&pos, &rot, 1.f)*camera.GetViewMatrix()));

		Effects.Get()->CommitChanges();
		meshSphere.RenderMesh();
	}
	Effects.EndEffect();

	FloatMap.EndScene();

	//BlurNormals
	FloatMap2.BeginScene();

	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("blur");
	Effects.Get()->SetMatrix("matProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", FloatMap.Texture);
	Effects.Get()->SetFloat("blur", 1.8f);
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();
	
	FloatMap2.EndScene();
	device->BeginScene();

	//DrawTexture
	float alphav = 0.f;
	if(time>46.f)
		alphav = CosineInterpolate(0.f, 1.f, Clamp((time-46)*.8f, 0.f, 1.f));

	if(time>72.38f)
		alphav = CosineInterpolate(1.f, 0.f, Clamp((time-72.38f)*.8f, 0.f, 1.f));

	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("normal");
	Effects.Get()->SetMatrix("matProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex1", FloatMap2.Texture);
	Effects.Get()->SetTexture("tex0", CubeMaps.Get("cubemap"));
	Effects.Get()->SetTexture("tex2", Textures.Get("test"));
	//Effects.Get()->SetTexture("tex2", Textures.Get("bigred"));
	Effects.Get()->SetFloat("alphavalue", alphav);
	Effects.BeginEffect(1);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();

//	DrawMap(FloatMap2.Texture);

	/***Text*******************************************************************************************************************/
	
	float t1a = .5f+.5f*sin(-(D3DX_PI/2.f)+ptime);
	float t2a = 1.f - t1a;
	if(ptime<D3DX_PI)
		t2a = 0.f;

	const char* ref1;
	const char* ref2;
	const char* list[] = {"keyboarders", "and", "boozoholics", "invites", "you", "you2", "kindergarden", "play", "blank"};

	int text = 0;
	float c=ptime/2.f;
	while(c> D3DX_PI) {c-=D3DX_PI;text++;};
	int text2 = 0;
	float d= (ptime/2.f)+(D3DX_PI/2.f);
	while(d> D3DX_PI) {d-=D3DX_PI;text2++;};

	
	if(text>8) text = 8;
	if(text2>8) text2 = 8;
	ref1 = list[text];
	ref2 = list[text2];	

	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(true);
	D3DXCOLOR ref = D3DXCOLOR(0x00801a1a);
	Effects.SetRef("text");
	Effects.Get()->SetMatrix("matWorldViewProjection", &(GetOrthoProjection(640.f, 480.f)) );
	Effects.Get()->SetTexture("tex0", Text.Get(ref1));
	Effects.Get()->SetFloat("time", time);
	Effects.Get()->SetFloat("alphavalue", t1a);
	Effects.Get()->SetFloatArray("ref", ref, 4);
	Effects.BeginEffect(0);
	TextPlane.RenderMesh();

	Effects.Get()->SetTexture("tex0", Text.Get(ref2));
	Effects.Get()->SetFloat("alphavalue", t2a);
	Effects.Get()->CommitChanges();
	TextPlane.RenderMesh();

	Effects.EndEffect();

	/***Overlay****************************************************************************************************************/

	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", Textures.Get("overlay"));
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();

	device->EndScene();
	device->Present(0,0,0,0);
}

void Scene02(float time, float ptime) //scene2
{	
	/***Pre Scene****************************************************************************************************************/
	ProduceGround(&GroundPlane, time*.5f);

//	printf("time = %f\n", time);
	camera.SetCamera(D3DXVECTOR3(-20.f+10.f*sinf(time*.2f), 43.f, -70.f), D3DXVECTOR3(00.f, 54.f, 00.f), D3DX_PI/3.2f);
	skycamera.SetCamera(D3DXVECTOR3(-70.f, 45.f, -00.f), D3DXVECTOR3(0.f, 64.f, 00.f), D3DX_PI/3.5f); // kamera2

	//lerpcam
	float q = Clamp((time-112.08)*.2f, 0.f, 1.f);
	//D3DXVec3Lerp(&camera.Position, &camera.Position, &skycamera.Position, q);
	camera.Position.x = CosineInterpolate(camera.Position.x, skycamera.Position.x, q);
	camera.Position.y = CosineInterpolate(camera.Position.y, skycamera.Position.y, q);
	camera.Position.z = CosineInterpolate(camera.Position.z, skycamera.Position.z, q);
	D3DXVec3Lerp(&camera.Target, &camera.Target, &skycamera.Target, q);

	camera.FOV = CosineInterpolate(camera.FOV, skycamera.FOV, q);

	hore.SetCamera(D3DXVECTOR3(5.f, 235.f,  -5.f), D3DXVECTOR3(00.f, 34.f, 10.f), D3DX_PI/4.2f); //skygge kamera


	light.SetCamera(D3DXVECTOR3(50.f*sinf(time), 55.f+15.f*sinf(time), 33.f*cosf(time)-20.f),   //ground trenger pos
					 D3DXVECTOR3(0.f, 00.f, 0.f), D3DX_PI/4.5f);


	/***Set Particles******************************************************************************************************/
	float particlealpha = 0.f;
	if(time>79.f)
		particlealpha = Clamp((time-79.f)*.1f, 0.f, 0.5f);

	float increase = 1.f;
	float zratio = D3DX_PI/200.f;
	float xratio = D3DX_PI/250.f;
	for(int i=0;i<Flow.particleNumber;i++)
	{
		Flow.particleBuffer[i].pos.z = -Wrap((time*10.f+i)*abs(PerlinNoise(i)+1.2f), 0.f, 200.f)+100.f;
		Flow.particleBuffer[i].pos.x = (PerlinNoise(i*62345.f)*125.f);
		Flow.particleBuffer[i].pos.y = -30.f + 60.f*sinf( (zratio* (Flow.particleBuffer[i].pos.z+100.f) ));
		Flow.particleBuffer[i].pos.y += 60.f*sinf( (xratio* (Flow.particleBuffer[i].pos.x+100.f) ));
	}

	/****Mr Shadow**********************************************************************************************************/

	ShadowMap.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(true, D3DBLENDOP_ADD, D3DBLEND_ONE, D3DBLEND_ONE);
	Effects.SetRef("particle2");
	Effects.Get()->SetMatrix("matView", &hore.GetViewMatrix());
	Effects.Get()->SetMatrix("matViewProjection", &hore.GetViewProjectionMatrix());
	Effects.Get()->SetTexture("tex0", Textures.Get("flow01"));
	Effects.Get()->SetFloat("ParticleSize", particlealpha);
	Effects.Get()->SetFloat("fadetoblack", 0.f);


	Effects.BeginEffect(1);
	Flow.RenderParticleStream();
	Effects.EndEffect();
	ShadowMap.EndScene();

	/***BackBuffer Rendring *****************************************************************************************************/
	device->BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);

	/***Sky**********************************************************************************************************************/

	skycamera.SetCamera(D3DXVECTOR3(-40.f, 10.f, 0.f), D3DXVECTOR3(0.f, 25.f, 0.f), D3DX_PI/2.8f);
	HIVCullModeZ(D3DCULL_CCW, false);
	HIVAlpha(true);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", & (HIVMatrixComplete(&D3DXVECTOR3(-00.f, -180.f, -00.f), &D3DXVECTOR3(time*.4f, 0.f, 0.f), 2.f)*skycamera.GetViewProjectionMatrix()));
	Effects.Get()->SetTexture("tex0", Textures.Get("colormap"));
	Effects.Get()->SetFloat("alpha", .8f);
	Effects.BeginEffect(1);
	Meshes.Get("hemi")->RenderMesh();
	Effects.EndEffect();


	/***Particles**********************************************************************************************/


	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(true, D3DBLENDOP_ADD, D3DBLEND_ONE, D3DBLEND_ONE);
	Effects.SetRef("particle2");
	Effects.Get()->SetMatrix("matView", &camera.GetViewMatrix());
	Effects.Get()->SetMatrix("matViewProjection", &camera.GetViewProjectionMatrix());
	Effects.Get()->SetTexture("tex0", Textures.Get("flow01"));
//	Effects.Get()->SetTexture("tex1", Textures.Get("keyalpha01"));
	Effects.Get()->SetFloat("fadetoblack", Clamp(time*.3f, 0.f, 1.f));
	Effects.Get()->SetFloat("tekstanim", (time*.3f)-1.f);
	Effects.Get()->SetFloat("anim", time);
	Effects.Get()->SetFloat("ParticleSize", particlealpha*2.f);
	Effects.BeginEffect(0);
	Flow.RenderParticleStream();
	Effects.EndEffect();


	/***Ground*****************************************************************************************************************/
	float commonY = -40.f;

	if(time>75.93f)
	{
		float d = (time-75.93f);
		float c = ((75.93f-time)*D3DX_PI);
		commonY +=  Clamp(d, 0.f, 1.f)*40.f;
		commonY += ((1.f-Clamp(d*.3f, 0.f, 1.f))*20.f)*sinf(c*2);
	}
	
	Effects.SetRef("ground1");
	Effects.Get()->SetMatrix("matWorldView", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, commonY, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), 1.0f)*camera.GetViewMatrix()));
	Effects.Get()->SetMatrix("matLightViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, commonY, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), 1.0f)*hore.GetViewProjectionMatrix()) );
	Effects.Get()->SetTexture("tex0", Textures.Get("colormap"));
	Effects.Get()->SetTexture("tex1", Textures.Get("fog1"));
	Effects.Get()->SetTexture("tex2", ShadowMap.Texture);
	Effects.Get()->SetFloatArray("LightPosition", light.Position, 3);
	Effects.Get()->SetFloat("TextureSpeed",  time*GBSPEED*-.1f);
	
	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_CW, false);
	/********render outline*************/
	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, commonY, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), 1.008f)*camera.GetViewProjectionMatrix()));
	Effects.BeginEffect(1);
	GroundPlane.RenderMeshDoubleBuffer();
	Effects.EndEffect();

	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_CW, true);
	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, commonY, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), 1.00f)*camera.GetViewProjectionMatrix()));
	Effects.BeginEffect(0);
	GroundPlane.RenderMesh();
	Effects.EndEffect();

	/***planestuff***************************************************************************************/

	//printf("time = %f\n", time);
	float csize = 0.f;

	static float b[] = {0.f,  122.32f, 123.04f, 125.78f, 126.57f, 127.77f, 128.44f, 131.29f, 132.85f, 133.62f, 135.f, 1000.f};
	int bounce = 0;
		while(b[bounce]<time) {bounce++;}

	if(time>118.49f)
	{
	//	printf("%f\n", b[bounce]-time);
		float k = sinf(Clamp(time-118.49f, 0.f, 1.f)*(D3DX_PI/2.f));
		csize += (b[bounce]-time)*k;
	}

	//out
	if(time>134.18f)
		csize = 1.f+ ((time-134.18f))*5.f;

	float canim = time*.1f;
	for(int i=0;i<Circles.particleNumber;i++)
	{
		float seed = PerlinNoise(i*i*61324);
		Circles.particleBuffer[i].pos = D3DXVECTOR3(0.f,
													70.f + (seed*20.f)*cosf(i+(time*seed)+(seed*54.f)), 
													(seed*30.f)*sinf(i+(time*seed)+(seed*72435.f)));
		//Circles.particleBuffer[i].normal.x =  (15.f*sinf(seed+time))*cosf(time+(seed*624.f));
		Circles.particleBuffer[i].normal.x =  csize*(15.f*abs(sinf(seed+time))+2.f)*cosf(time+(seed*624.f));
	}

	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("particle2");
	Effects.Get()->SetMatrix("matViewProjection", &(camera.GetViewProjectionMatrix())); //worldview
	Effects.Get()->SetTexture("tex0", Textures.Get("circle"));
	
	//white
	Effects.BeginEffect(3);
	Circles.RenderParticleStream();
	Effects.EndEffect();
	device->EndScene();
	FullScreenBuffer.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x00, 1.f, 0); //0xe43636

	//red + scene2
	Effects.BeginEffect(2);
	Circles.RenderParticleStream();
	Effects.EndEffect();
	FullScreenBuffer.EndScene();
	FullScreenBuffer2.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	Scene2(time);
	FullScreenBuffer2.EndScene();

	device->BeginScene();
	HIVAlpha(true);//
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("fullscreen");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
//	Effects.Get()->SetTexture("tex0", Textures.Get("test"));
	Effects.Get()->SetTexture("tex0", FullScreenBuffer2.Texture);
	Effects.Get()->SetTexture("tex1", FullScreenBuffer.Texture);
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();

	/***Lines******************************************************************************************************************/
	camera2.SetCamera(D3DXVECTOR3(-20.f+10.f*sinf(time*.1f), 45.f, -70.f), D3DXVECTOR3(00.f, 54.f, 00.f), D3DX_PI/3.2f);
	float x = -200.f;
		x = Wrap((time-5.f)*50.f, 0.f, 300.f)-150.f;
	MakeCurvedLine(&meshLine, 20.f, 10.f, time*50.f, 100, 212234, false);

	//white
	device->Clear(0, NULL, D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, true);
	Effects.SetRef("Line");
	Effects.Get()->SetTexture("tex0", Textures.Get("line"));
	Effects.Get()->SetMatrix("matWorldViewProjection", &camera2.GetWVPMatrix(&HIVMatrixComplete(x, 50.f, -57.f, D3DX_PI/2.f, D3DX_PI/2.f, 0.f, 1.f)));
	Effects.BeginEffect(0);
	meshLine.RenderMesh();
	Effects.EndEffect();
	device->EndScene();

	FullScreenBuffer.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x00, 1.f, 0); //0xe43636
	Effects.SetRef("Line");
	Effects.Get()->SetTexture("tex0", Textures.Get("line"));
	Effects.Get()->SetMatrix("matWorldViewProjection", &camera2.GetWVPMatrix(&HIVMatrixComplete(x, 50.f, -57.f, D3DX_PI/2.f, D3DX_PI/2.f, 0.f, 1.f)));
	Effects.BeginEffect(1);
	meshLine.RenderMesh();
	Effects.EndEffect();
	FullScreenBuffer.EndScene();

	FullScreenBuffer2.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	Scene2Simple(time);
	FullScreenBuffer2.EndScene();

	device->BeginScene();
	HIVAlpha(true);//
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("fullscreen");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", FullScreenBuffer2.Texture);
	Effects.Get()->SetTexture("tex1", FullScreenBuffer.Texture);
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();

	/***Text*******************************************************************************************************************/

	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(true);
	D3DXCOLOR ref = D3DXCOLOR(0x00801a1a);
	Effects.SetRef("text");

	const char* ref1 = "sympathy";

	float t1a = 0.f;
	if(time>93.f)
		t1a = CosineInterpolate(0.f, 1.f, Clamp( (time-93.f)*.8f, 0.f, 1.f));
	if(time>98.f)
		t1a = CosineInterpolate(1.f, 0.f, Clamp( (time-98.f)*.8f, 0.f, 1.f));

	Effects.Get()->SetMatrix("matWorldViewProjection", &(GetOrthoProjection(640.f, 480.f)) );
	Effects.Get()->SetTexture("tex0", Text.Get(ref1));
	Effects.Get()->SetFloat("time", time);
	Effects.Get()->SetFloat("alphavalue", t1a);
	Effects.Get()->SetFloatArray("ref", ref, 4);
	Effects.BeginEffect(0);
	TextPlane.RenderMesh();
	Effects.EndEffect();

	/***Overlay****************************************************************************************************************/

	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", Textures.Get("overlay"));
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();

	device->EndScene();
	device->Present(0,0,0,0);
}

void Scene03(float time, float ptime)//scene2max
{
/*
	FullScreenBuffer2.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	Scene2Max(time, ptime);
	FullScreenBuffer2.EndScene();

//	BlurMap.CopyCurrentTarget();

	device->BeginScene();
	HIVAlpha(false);//
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", FullScreenBuffer2.Texture);
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();
*/
//tegn rett inn istedet
	device->BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	Scene2Max(time, ptime);
	
//glow
/*	
	HIVAlpha(true);//
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("fullscreen");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", FullScreenBuffer2.Texture);
	Effects.BeginEffect(1);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();
	
*/
	/***Lines******************************************************************************************************************/
	camera2.SetCamera(D3DXVECTOR3(-20.f+10.f*sinf(time*.1f), 45.f, -70.f), D3DXVECTOR3(00.f, 54.f, 00.f), D3DX_PI/3.2f);
	float x = -200.f;
		x = Wrap((time-5.f)*50.f, 0.f, 300.f)-150.f;
	MakeCurvedLine(&meshLine, 20.f, 10.f, time*50.f, 100, 5424234, false);

	//white
	device->Clear(0, NULL, D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, true);
	Effects.SetRef("Line");
	Effects.Get()->SetTexture("tex0", Textures.Get("line"));
	Effects.Get()->SetMatrix("matWorldViewProjection", &camera2.GetWVPMatrix(&HIVMatrixComplete(x, 50.f, -57.f, D3DX_PI/2.f, D3DX_PI/2.f, 0.f, 1.f)));
	Effects.BeginEffect(0);
	meshLine.RenderMesh();
	Effects.EndEffect();
	device->EndScene();

	FullScreenBuffer.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x00, 1.f, 0); //0xe43636
	Effects.SetRef("Line");
	Effects.Get()->SetTexture("tex0", Textures.Get("line"));
	Effects.Get()->SetMatrix("matWorldViewProjection", &camera2.GetWVPMatrix(&HIVMatrixComplete(x, 50.f, -57.f, D3DX_PI/2.f, D3DX_PI/2.f, 0.f, 1.f)));
	Effects.BeginEffect(1);
	meshLine.RenderMesh();
	Effects.EndEffect();
	FullScreenBuffer.EndScene();

	FullScreenBuffer2.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	Scene1Simple(time);
	FullScreenBuffer2.EndScene();

	device->BeginScene();
	HIVAlpha(true);//
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("fullscreen");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", FullScreenBuffer2.Texture);
	Effects.Get()->SetTexture("tex1", FullScreenBuffer.Texture);
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();


	/***Text*******************************************************************************************************************/
	float ttime = 0.f;
	if(time > 155.f)
		ttime = time-155.f;

	float t1a = .5f+.5f*sin(-(D3DX_PI/2.f)+ttime);
	float t2a = 1.f - t1a;
	if(ttime<D3DX_PI)
		t2a = 0.f;

	const char* ref1;
	const char* ref2;
	//const char* list[] = {"keyboarders", "and", "boozoholics", "invites", "you", "you2", "kindergarden", "play", "blank"};
	const char* list[] = {"caudio", "clugge", "cvisuals", "cquisten", "blank"};

	int text = 0;
	float c=ttime/2.f;
	while(c> D3DX_PI) {c-=D3DX_PI;text++;};
	int text2 = 0;
	float d= (ttime/2.f)+(D3DX_PI/2.f);
	while(d> D3DX_PI) {d-=D3DX_PI;text2++;};

	
	if(text>4) text = 4;
	if(text2>4) text2 = 4;
	ref1 = list[text];
	ref2 = list[text2];	

	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(true);
	D3DXCOLOR ref = D3DXCOLOR(0x00801a1a);
	Effects.SetRef("text");
	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixPosition(0.f, -80.f, 0.f)*GetOrthoProjection(640.f, 480.f)) );
	Effects.Get()->SetTexture("tex0", Text.Get(ref1));
	Effects.Get()->SetFloat("time", time);
	Effects.Get()->SetFloat("alphavalue", t1a);
	Effects.Get()->SetFloatArray("ref", ref, 4);
	Effects.BeginEffect(0);
	TextPlane.RenderMesh();

	Effects.Get()->SetTexture("tex0", Text.Get(ref2));
	Effects.Get()->SetFloat("alphavalue", t2a);
	Effects.Get()->CommitChanges();
	TextPlane.RenderMesh();

//	printf("time = %f\n" ,time);
	Effects.EndEffect();

	/***Overlay*************************************************************************************/
	float alphascene = 0.f;
	if(time>186.67f)
		alphascene = (time-186.67f)/2.f;

	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", Textures.Get("black"));
	Effects.Get()->SetFloat("alpha", alphascene);
	Effects.BeginEffect(1);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();


	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", Textures.Get("overlay"));
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();


//	DrawMap(ShadowMap.Texture);
	device->EndScene();
	device->Present(0,0,0,0);
};
 
void SceneTest(float time)
{
	printf("time = %f\n", time);
	ProduceGround(&GroundPlane, time*.5f);

	float increase = 1.f;
	float zratio = D3DX_PI/200.f;
	float xratio = D3DX_PI/250.f;
	for(int i=0;i<Flow.particleNumber;i++)
	{
		Flow.particleBuffer[i].pos.z = -Wrap((time*35.f+i)*abs(PerlinNoise(i)+1.2f), 0.f, 200.f)+100.f;
		Flow.particleBuffer[i].pos.x = (PerlinNoise(i*62345.f)*125.f);
	//	Flow.particleBuffer[i].pos.y = -30.f + 70.f*sinf( (zratio* (Flow.particleBuffer[i].pos.z+100.f) ));
	//	Flow.particleBuffer[i].pos.y += 70.f*sinf( (xratio* (Flow.particleBuffer[i].pos.x+100.f) ));

		Flow.particleBuffer[i].pos.y = -30.f + 60.f*sinf( (zratio* (Flow.particleBuffer[i].pos.z+100.f) ));
		Flow.particleBuffer[i].pos.y += 60.f*sinf( (xratio* (Flow.particleBuffer[i].pos.x+100.f) ));
		//printf("pos.y = %f\n", Flow.particleBuffer[i].pos.y );
	}
	
	/******************************************/
	float ctime = time*1.f;

	camera.SetCamera(D3DXVECTOR3(-40.f, 45.f,  -70.f), D3DXVECTOR3(00.f, 54.f, 00.f), D3DX_PI/3.2f); //funker best
	camera.SetCamera(D3DXVECTOR3(-20.f+20.f*sinf(time*.1f), 45.f, -70.f), D3DXVECTOR3(00.f, 54.f, 00.f), D3DX_PI/3.2f); //funker best
	

	//camera.SetCamera(D3DXVECTOR3(100.f*sinf(ctime), 125.f, 100.f*cosf(time)), D3DXVECTOR3(0.f, 20.f, 00.f), D3DX_PI/2.5f); //oversikt
//	camera.SetCamera(D3DXVECTOR3(-70.f, 45.f, -00.f), D3DXVECTOR3(0.f, 64.f, 00.f), D3DX_PI/3.5f); //oversikt
	

	light.SetCamera(D3DXVECTOR3(50.f*sinf(ctime), 55.f+15.f*sinf(time), 33.f*cosf(ctime)-20.f), 
					 D3DXVECTOR3(0.f, 00.f, 0.f), D3DX_PI/4.5f);

	//hore.SetCamera(D3DXVECTOR3(50.f, 85.f, -70.f), D3DXVECTOR3(100.f, 00.f, 50.f), D3DX_PI/2.5f);
	//hore.SetCamera(D3DXVECTOR3(0.f, 85.f, -1.f), D3DXVECTOR3(0.f, 10.f, 1.f), D3DX_PI/3.5f);

	hore.SetCamera(D3DXVECTOR3(5.f, 235.f,  -5.f), D3DXVECTOR3(00.f, 34.f, 10.f), D3DX_PI/4.2f); //funker best
//	hore.SetCamera(D3DXVECTOR3(5.f, 335.f,  -5.f), D3DXVECTOR3(00.f, 34.f, 10.f), D3DX_PI/3.2f); //funker best




	/****Mr Shadow**********************************************************************************************************/
	ShadowMap.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);

	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(true, D3DBLENDOP_ADD, D3DBLEND_ONE, D3DBLEND_ONE);

	Effects.SetRef("particle2");
	Effects.Get()->SetMatrix("matView", &hore.GetViewMatrix());
	Effects.Get()->SetMatrix("matViewProjection", &hore.GetViewProjectionMatrix());
	Effects.Get()->SetTexture("tex0", Textures.Get("flow01"));
	Effects.Get()->SetFloat("ParticleSize", 1.5f);
	Effects.Get()->SetFloat("fadetoblack", Clamp(time*.3f, 0.f, 1.f));
	Effects.Get()->SetFloat("tekstanim", (time*.3f)-1.f);
	Effects.BeginEffect(1);
	Flow.RenderParticleStream();
	Effects.EndEffect();

	ShadowMap.EndScene();

	/**************************************************************************************************************************/

	device->BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);

	/*Sky**********************************************************************************************************************/

	skycamera.SetCamera(D3DXVECTOR3(-40.f, 20.f, 0.f), D3DXVECTOR3(0.f, 25.f, 0.f), D3DX_PI/3.8f);
	HIVCullModeZ(D3DCULL_CCW, false);
	HIVAlpha(true);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", & (HIVMatrixComplete(&D3DXVECTOR3(-00.f, -120.f, -00.f), &D3DXVECTOR3(time*.7f, 0.f, 0.f), 2.f)*skycamera.GetViewProjectionMatrix()));
	Effects.Get()->SetTexture("tex0", Textures.Get("colormap"));
	Effects.Get()->SetFloat("alpha", .7f);
	Effects.BeginEffect(1);
	Meshes.Get("hemi")->RenderMesh();
	Effects.EndEffect();
	


	/**Particles**********************************************************************************************/


	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(true, D3DBLENDOP_ADD, D3DBLEND_ONE, D3DBLEND_ONE);

	Effects.SetRef("particle2");
	Effects.Get()->SetMatrix("matView", &camera.GetViewMatrix());
	Effects.Get()->SetMatrix("matViewProjection", &camera.GetViewProjectionMatrix());
	Effects.Get()->SetTexture("tex0", Textures.Get("flow01"));
	Effects.Get()->SetTexture("tex1", Textures.Get("keyalpha01"));
	Effects.Get()->SetFloat("fadetoblack", Clamp(time*.3f, 0.f, 1.f));
	Effects.Get()->SetFloat("tekstanim", (time*.3f)-1.f);
	Effects.Get()->SetFloat("anim", time);
	Effects.Get()->SetFloat("ParticleSize", 3.f);

	Effects.BeginEffect(0);
	Flow.RenderParticleStream();
	Effects.EndEffect();
	
	/*Ground*******************************************************************************************************/		

	Effects.SetRef("ground1");
//	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixRotation(0.f, D3DX_PI/2.f, 0.f)*camera.GetViewProjectionMatrix()));
	Effects.Get()->SetMatrix("matWorldView", &(HIVMatrixRotation(0.f, D3DX_PI/2.f, 0.f)*camera.GetViewMatrix()));
//	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixRotation(0.f, D3DX_PI/2.f, 0.f)*hore.GetViewProjectionMatrix()));
//	Effects.Get()->SetMatrix("matWorldView",           &(HIVMatrixRotation(0.f, D3DX_PI/2.f, 0.f)*hore.GetViewMatrix()));	
	Effects.Get()->SetMatrix("matLightViewProjection", &(HIVMatrixRotation(0.f, D3DX_PI/2.f, 0.f)*hore.GetViewProjectionMatrix()) );

	//Effects.Get()->SetTexture("tex0", Textures.Get("normalmap1"));
	Effects.Get()->SetTexture("tex0", Textures.Get("colormap"));
	Effects.Get()->SetTexture("tex1", Textures.Get("fog1"));
	Effects.Get()->SetTexture("tex2", ShadowMap.Texture);
	Effects.Get()->SetFloatArray("LightPosition", light.Position, 3);
	Effects.Get()->SetFloat("TextureSpeed",  time*GBSPEED*-.1f);
	
	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_CW, false);
	//render outline
	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, 0.f, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), 1.005f)*camera.GetViewProjectionMatrix()));
	Effects.BeginEffect(1);
	GroundPlane.RenderMeshDoubleBuffer();
	Effects.EndEffect();

	
	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_CW, true);
	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixRotation(0.f, D3DX_PI/2.f, 0.f)*camera.GetViewProjectionMatrix()));
	Effects.BeginEffect(0);
	GroundPlane.RenderMesh();
//	GroundPlane.RenderMeshDoubleBuffer();
	Effects.EndEffect();


	
/*****planestuff***************************************************************************************/

	float canim = time*.1f;
	for(int i=0;i<Circles.particleNumber;i++)
	{
		float seed = PerlinNoise(i*i*61324);
		Circles.particleBuffer[i].pos = D3DXVECTOR3(0.f,
													70.f + (seed*20.f)*cosf(i+(time*seed)+(seed*54.f)), 
													(seed*30.f)*sinf(i+(time*seed)+(seed*72435.f)));
		//Circles.particleBuffer[i].normal.x =  (15.f*sinf(seed+time))*cosf(time+(seed*624.f));
		Circles.particleBuffer[i].normal.x =  (15.f*abs(sinf(seed+time))+2.f)*cosf(time+(seed*624.f));
	}

	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("particle2");
	Effects.Get()->SetMatrix("matWorldViewProjection", &(camera.GetViewProjectionMatrix()));
	Effects.Get()->SetTexture("tex0", Textures.Get("circle"));
	
	//white
	Effects.BeginEffect(3);
	Circles.RenderParticleStream();
	Effects.EndEffect();

	device->EndScene();
	FullScreenBuffer.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x00, 1.f, 0); //0xe43636

	//red
	
	Effects.BeginEffect(2);
	Circles.RenderParticleStream();
	Effects.EndEffect();
	


	FullScreenBuffer.EndScene();

	FullScreenBuffer2.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	Scene2(time);
	FullScreenBuffer2.EndScene();

	device->BeginScene();

	HIVAlpha(true);//
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("fullscreen");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
//	Effects.Get()->SetTexture("tex0", Textures.Get("test"));
	Effects.Get()->SetTexture("tex0", FullScreenBuffer2.Texture);
	Effects.Get()->SetTexture("tex1", FullScreenBuffer.Texture);
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();



	//HIVAlpha(true);//
	//HIVCullModeZ(D3DCULL_NONE, false);
	//Effects.SetRef("texture");
	//Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	//Effects.Get()->SetTexture("tex0", FullScreenBuffer.Texture);
	//Effects.BeginEffect(0);
	//ScreenPlane.RenderMesh();
	//Effects.EndEffect();

	/***Overlay***************************************************************************************/

	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", Textures.Get("overlay"));
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();

//	DrawMap(ShadowMap.Texture);
	device->EndScene();
	device->Present(0, 0, 0, 0);
	return; 
};


void Scene2(float time)
{
	/***Prep***********************************************************************************/
	D3DXVECTOR3 ObjPos = D3DXVECTOR3(0.f, 20.f, 0.f);
	camera.SetCamera(D3DXVECTOR3(110.f, 20.f, 00.f), D3DXVECTOR3(0.f,  0.f, 00.f), D3DX_PI/3.0f); //oversikt
	float ctime = time*.2f;
	float amp = 110.f;
//	camera.SetCamera(D3DXVECTOR3(110.f*sinf(ctime), 20.f, 110.f*cosf(ctime)), D3DXVECTOR3(0.f,  0.f, 00.f), D3DX_PI/3.0f); //oversikt

	camera.SetCamera(D3DXVECTOR3(amp*sinf(ctime), 20.f, amp*cosf(ctime)), D3DXVECTOR3(0.f,  20.f, 00.f), D3DX_PI/3.0f); //oversikt
	
	/***sky***********************************************************************************/
	skycamera.SetCamera(D3DXVECTOR3(-40.f, 20.f, 0.f), D3DXVECTOR3(0.f, 25.f, 0.f), D3DX_PI/3.8f);
	HIVCullModeZ(D3DCULL_CCW, false);
	HIVAlpha(false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", & (HIVMatrixComplete(&D3DXVECTOR3(-00.f, -220.f, -00.f), &D3DXVECTOR3(time*.7f, 0.f, 0.f), 1.f)*skycamera.GetViewProjectionMatrix()));
	Effects.Get()->SetTexture("tex0", Textures.Get("bigred"));
	Effects.Get()->SetFloat("alpha", .7f);
	Effects.BeginEffect(1);
	Meshes.Get("hemi")->RenderMesh();
	Effects.EndEffect();


	/***objekt*****************************************************************************/
	D3DXVECTOR3 CameraVector;
	D3DXVec3Normalize(&CameraVector, &(camera.Position-camera.Target));


	HIVCullModeZ(D3DCULL_CCW, true);
	HIVAlpha(false);
	Effects.SetRef("obj1");
//	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(-00.f, 0.f, -00.f), &D3DXVECTOR3(time*.7f, time*.4f, time*.3f), 1.f)*camera.GetViewProjectionMatrix()));
//	Effects.Get()->SetMatrix("matWorldView", &(HIVMatrixComplete(&D3DXVECTOR3(-00.f, 0.f, -00.f), &D3DXVECTOR3(time*.7f, time*.4f, time*.3f), 1.f)*camera.GetViewMatrix()));
	Effects.Get()->SetMatrix("matWorldViewProjection", &camera.GetWVPMatrix(&HIVMatrixComplete(&ObjPos, &D3DXVECTOR3(time*.7f, time*.4f, time*.3f), 1.f)));
	Effects.Get()->SetMatrix("matWorldView", &camera.GetWorldViewMatrix(&HIVMatrixComplete(&ObjPos, &D3DXVECTOR3(time*.7f-(D3DX_PI/2.f), time*.4f, time*.3f), 1.f)));

	Effects.Get()->SetFloatArray("CameraVector", CameraVector, 3);
	Effects.Get()->SetTexture("tex0", CubeMaps.Get("cubemap"));
	Effects.BeginEffect(0);
	MongoObj.RenderMesh();
	Effects.EndEffect();

	/***Ground******************************************************************************/
}

void EndScene(float time, float ptime)
{
	device->BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);

	/***Sky**********************************************************************************************/
	skycamera.SetCamera(D3DXVECTOR3(-40.f, 20.f, 0.f), D3DXVECTOR3(0.f, 25.f, 0.f), D3DX_PI/3.8f);
	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, -220.f, 0.f), &D3DXVECTOR3(time*.7f, 0.f, 0.f), 1.f)*skycamera.GetViewProjectionMatrix()));
	Effects.Get()->SetTexture("tex0", Textures.Get("colormap"));
	Effects.Get()->SetFloat("alpha", .7f);
	Effects.BeginEffect(1);
	Meshes.Get("hemi")->RenderMesh();
	Effects.EndEffect();


	/***Rde sirkler**************************************************************************************/
	
	camera.SetCamera(D3DXVECTOR3(-60.f*sinf(time), 0.f, -60.f*cosf(time)), D3DXVECTOR3(00.f, 54.f, 00.f), D3DX_PI/3.2f);

	float csize = 1.4f;



	for(int i=0;i<Circles.particleNumber;i++)
	{
		float seed = PerlinNoise(i*i*61324);
		Circles.particleBuffer[i].pos = D3DXVECTOR3((seed*40.f)*cosf(i+(time*seed)+(seed*54.f)),
													70.f + (seed*40.f)*cosf(i+(time*seed)+(seed*54.f)), 
													(seed*40.f)*sinf(i+(time*seed)+(seed*72435.f)));
		Circles.particleBuffer[i].normal.x =  csize*(15.f*abs(sinf(seed+time))+2.f)*cosf(time+(seed*624.f));
	}

	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("particle2");
	Effects.Get()->SetMatrix("matViewProjection", &(camera.GetViewProjectionMatrix())); //worldview
	Effects.Get()->SetMatrix("matView", &(camera.GetViewMatrix())); //worldview
	Effects.Get()->SetTexture("tex0", Textures.Get("circle"));
	
	//white
	Effects.BeginEffect(3);
	Circles.RenderParticleStream();
	Effects.EndEffect();
	device->EndScene();
	FullScreenBuffer.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x00, 1.f, 0); //0xe43636

	//red + scene2
	Effects.BeginEffect(2);
	Circles.RenderParticleStream();
	Effects.EndEffect();
	FullScreenBuffer.EndScene();
	FullScreenBuffer2.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	Scene2End(time);
	FullScreenBuffer2.EndScene();

	device->BeginScene();
	HIVAlpha(true);//
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("fullscreen");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
//	Effects.Get()->SetTexture("tex0", Textures.Get("test"));
	Effects.Get()->SetTexture("tex0", FullScreenBuffer2.Texture);
	Effects.Get()->SetTexture("tex1", FullScreenBuffer.Texture);
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();

	/***Normal piss**************************************************************************************/
/*
	device->EndScene();
	
	FloatMap.BeginScene();

	device->Clear(0, NULL,D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0xffffffff, 1.f, 0);

	float mtime = D3DX_PI/2.f;
	camera.SetCamera(D3DXVECTOR3(-200.f*sinf(mtime), 45.f, -200.f*cosf(mtime)), D3DXVECTOR3(00.f, 0.f, 00.f), D3DX_PI/3.2f);
	
	D3DXVECTOR3 cm =  camera.Target-camera.Position;
	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_CCW, true);
	Effects.SetRef("normal");
	Effects.Get()->SetTexture("tex0", CubeMaps.Get("cubemap"));
	Effects.Get()->SetFloatArray("camera", cm, 3);
	
	Effects.BeginEffect(0);
	
	float sync = -1.f;//pow(fft.Gain(3.1f, .01f, time)+1.f, 2);
	float canim = time*.1f;
	for(int i=0;i<40.f;i++)
	{
		float seed = PerlinNoise(i*i*61324*i);
		D3DXVECTOR3 pos = D3DXVECTOR3(40.f + (seed*60.f)*cosf(i+(time*seed)+(seed*523144.f)), 
			60.f+(seed*60.f)*sinf(i+(time*seed)+(seed*72435.f))-50.f, 
			10.f+(seed*60.f)*sinf(cosf(i)+(time*seed)+(seed*7241234135.f)));

		float s =  (abs(sinf(seed+time))+2.f) *cosf(time+(seed*624.f));
		s = Clamp(s, 0.f, 3.f);

		s*=sync;

		D3DXVECTOR3 rot = D3DXVECTOR3(0.f, 0.f, 0.f);
		Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&pos, &rot,s )*camera.GetViewProjectionMatrix()));
		rot.x -= (D3DX_PI/2.f);
		Effects.Get()->SetMatrix("matWorldView", &(HIVMatrixComplete(&pos, &rot, 1.f)*camera.GetViewMatrix()));

		Effects.Get()->CommitChanges();
		meshSphere.RenderMesh();
	}
	Effects.EndEffect();

	FloatMap.EndScene();

	//BlurNormals
	FloatMap2.BeginScene();

	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("blur");
	Effects.Get()->SetMatrix("matProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", FloatMap.Texture);
	Effects.Get()->SetFloat("blur", 1.8f);
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();
	
	FloatMap2.EndScene();
	device->BeginScene();

	//DrawTexture

	float alphav = 1.f;

	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("normal");
	Effects.Get()->SetMatrix("matProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex1", FloatMap2.Texture);
	Effects.Get()->SetTexture("tex0", CubeMaps.Get("cubemap"));
	Effects.Get()->SetTexture("tex2", Textures.Get("test"));
	//Effects.Get()->SetTexture("tex2", Textures.Get("bigred"));
	Effects.Get()->SetFloat("alphavalue", alphav);
	Effects.BeginEffect(1);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();
*/
	/***Text***********************************************************************************************************/
	ptime*=1.55f;
	float t1a = .5f+.5f*sin(-(D3DX_PI/2.f)+ptime);
	float t2a = 1.f - t1a;
	if(ptime<D3DX_PI)
		t2a = 0.f;

	const char* ref1;
	const char* ref2;
	//const char* list[] = {"keyboarders", "and", "boozoholics", "invites", "you", "you2", "kindergarden", "play", "blank"};
	const char* list[] = {"ekg", "ehaga", "edata", "eslogan", "blank"};

	int text = 0;
	float c=ptime/2.f;
	while(c> D3DX_PI) {c-=D3DX_PI;text++;};
	int text2 = 0;
	float d= (ptime/2.f)+(D3DX_PI/2.f);
	while(d> D3DX_PI) {d-=D3DX_PI;text2++;};

	
	if(text>8) text = 8;
	if(text2>8) text2 = 8;
	ref1 = list[text];
	ref2 = list[text2];	

	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(true);
	D3DXCOLOR ref = D3DXCOLOR(0x00801a1a);
	Effects.SetRef("text");
	Effects.Get()->SetMatrix("matWorldViewProjection", &(GetOrthoProjection(640.f, 480.f)) );
	Effects.Get()->SetTexture("tex0", Text.Get(ref1));
	Effects.Get()->SetFloat("time", time);
	Effects.Get()->SetFloat("alphavalue", t1a);
	Effects.Get()->SetFloatArray("ref", ref, 4);
	Effects.BeginEffect(0);
	TextPlane.RenderMesh();

	Effects.Get()->SetTexture("tex0", Text.Get(ref2));
	Effects.Get()->SetFloat("alphavalue", t2a);
	Effects.Get()->CommitChanges();
	TextPlane.RenderMesh();

	Effects.EndEffect();


	/***Overlay**************************************************************************************/

	float alphascene = 0.f;
	if(time>202.5f)
		alphascene = CosineInterpolate(0.f, 1.f, (time-202.5f)/2.f);


	if(time<189.6f)
		alphascene = 1.f - (time-188.6f);
	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", Textures.Get("black"));
	Effects.Get()->SetFloat("alpha", alphascene);
	Effects.BeginEffect(1);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();


	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", Textures.Get("overlay"));
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();


	device->EndScene();
	device->Present(0,0,0,0);
}

void Scene2Max(float time, float ptime)
{
	/***Prep***********************************************************************************/
	D3DXVECTOR3 ObjPos = D3DXVECTOR3(0.f, 20.f, 0.f);
	float ObjScl = 1.f;
	if(time>144.3f)
	{
		ObjScl -=  (Clamp((time-144.3f), 0.f, 1.f)*.4f);
		ObjPos.y = CosineInterpolate( 20.f, 50.f, Clamp((time-144.3f), 0.f, 1.f));
	}

	//printf("obj = %f\n", ObjScl);
	float ctime = time*.2f;
	float amp = 110.f;
	camera.SetCamera(D3DXVECTOR3(amp*sinf(ctime), 20.f, amp*cosf(ctime)), D3DXVECTOR3(0.f,  20.f, 00.f), D3DX_PI/3.0f); //oversikt

	ctime = time*.4f;
//	hore.SetCamera(D3DXVECTOR3(5.f, 235.f,  -5.f), D3DXVECTOR3(00.f, 34.f, 10.f), D3DX_PI/4.2f); //skygge kamera
		hore.SetCamera(D3DXVECTOR3(30*sinf(ctime+D3DX_PI), 120.f, 30*cosf(ctime+D3DX_PI)), D3DXVECTOR3(0.f,  00.f, 00.f), D3DX_PI/2.0f); //oversikt

	light.SetCamera(D3DXVECTOR3(50.f*sinf(time), 55.f+15.f*sinf(time), 33.f*cosf(time)-20.f),   //ground trenger pos
					 D3DXVECTOR3(0.f, 00.f, 0.f), D3DX_PI/4.5f);

	ProduceGround2(&GroundPlane, time*.5f, time);

    // camera.SetCamera(D3DXVECTOR3(-40.f*sinf(time), 50.f, -40.f*cosf(time) ), D3DXVECTOR3(-30.f*sinf(time-D3DX_PI),  30.f, -20.f*cosf(time-D3DX_PI)), D3DX_PI/3.0f); //oversikt
	camera.SetCamera(D3DXVECTOR3(60.f, 10.f, 60.f), D3DXVECTOR3(0.f, 30.f, 0.f), D3DX_PI/2.5f); //oversikt



	float change = 0;
	if(time>170.f)
		change = Clamp((time-170.f)*.5f, 0.f, 1.f);
	camera.Position.x = CosineInterpolate(amp*sinf(ctime), 60.f, change);
	camera.Position.y = CosineInterpolate(20.f, 10.f, change);
	camera.Position.z = CosineInterpolate(amp*cosf(ctime), 60.f, change);

	camera.Target.x  = 0.f;
	camera.Target.y = CosineInterpolate(20.f, 30.f, change);
	camera.Target.z = 0.f;

	camera.FOV = CosineInterpolate(D3DX_PI/3.f, D3DX_PI/2.5f, change);
	/***skygge********************************************************************************/
	
	device->EndScene();
	ShadowMap.BeginScene();
	device->Clear(0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0x0, 1.f, 0);
	
	HIVAlpha(false);
	Effects.SetRef("obj1");
	Effects.Get()->SetMatrix("matWorldViewProjection", &hore.GetWVPMatrix(&HIVMatrixComplete(&ObjPos, &D3DXVECTOR3(time*.7f, time*.4f, time*.3f), ObjScl)));
	Effects.Get()->SetMatrix("matWorldView", &hore.GetWorldViewMatrix(&HIVMatrixComplete(&ObjPos, &D3DXVECTOR3(time*.7f-(D3DX_PI/2.f), time*.4f, time*.3f), 1.f)));
	Effects.Get()->SetTexture("tex0", CubeMaps.Get("cubemap"));
	Effects.BeginEffect(1);
	MongoObj.RenderMesh();
	Effects.EndEffect();

	ShadowMap.EndScene();

	device->BeginScene();
	/***sky***********************************************************************************/
	skycamera.SetCamera(D3DXVECTOR3(-40.f, 20.f, 0.f), D3DXVECTOR3(0.f, 25.f, 0.f), D3DX_PI/3.8f);
	HIVCullModeZ(D3DCULL_CCW, false);
	HIVAlpha(false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", & (HIVMatrixComplete(&D3DXVECTOR3(-00.f, -220.f, -00.f), &D3DXVECTOR3(time*.7f, 0.f, 0.f), 1.f)*skycamera.GetViewProjectionMatrix()));
	Effects.Get()->SetTexture("tex0", Textures.Get("bigred"));
	Effects.Get()->SetFloat("alpha", .7f);
	Effects.BeginEffect(1);
	Meshes.Get("hemi")->RenderMesh();
	Effects.EndEffect();

	/***Rde sirkler**************************************************************************************/
	
	skycamera.SetCamera(D3DXVECTOR3(-60.f*sinf(time), 0.f, -60.f*cosf(time)), D3DXVECTOR3(00.f, 54.f, 00.f), D3DX_PI/3.2f);
	float csize = 1.4f;
	for(int i=0;i<Circles.particleNumber;i++)
	{
		
		float seed = PerlinNoise(i*i*61324);
		Circles.particleBuffer[i].pos = D3DXVECTOR3((seed*70.f)*cosf(i+(time*seed)+(seed*53544.f)),
													70.f + (seed*70.f)*cosf(i+(time*seed)+(seed*54.f)), 
													(seed*70.f)*sinf(i+(time*seed)+(seed*72435.f)));
		Circles.particleBuffer[i].normal.x =  Clamp(csize*(15.f*abs(sinf(seed+time))+2.f)*cosf(time+(seed*624.f)), 0.f, 10.f);
		

	//	Circles.particleBuffer[i].pos = D3DXVECTOR3(0.f, 0.f, (i-25)*3.f);
	//	Circles.particleBuffer[i].normal.x = 2.f;
	}

	float mongo = 0.f;

	if(time>136.f)
		mongo = CosineInterpolate( 0.f, .1f, Clamp((time-136.f)*.5f, 0.f, 1.f));
	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("particle2");
	Effects.Get()->SetMatrix("matViewProjection", &(skycamera.GetViewProjectionMatrix())); //worldview
	Effects.Get()->SetMatrix("matView", &(skycamera.GetViewMatrix())); //worldview
	Effects.Get()->SetFloat("mongo", mongo);
	Effects.Get()->SetTexture("tex0", Textures.Get("circle"));

	//white
	Effects.BeginEffect(4);
	Circles.RenderParticleStream();
	Effects.EndEffect();
//	device->EndScene();

	/***objekt*****************************************************************************/
/*
	D3DXVECTOR3 CameraVector;
	D3DXVec3Normalize(&CameraVector, &(camera.Position-camera.Target));
	HIVCullModeZ(D3DCULL_CCW, true);
	HIVAlpha(false);
	Effects.SetRef("obj1");
	Effects.Get()->SetMatrix("matWorldViewProjection", &camera.GetWVPMatrix(&HIVMatrixComplete(&ObjPos, &D3DXVECTOR3(time*.7f, time*.4f, time*.3f), ObjScl)));
	Effects.Get()->SetMatrix("matWorldView", &camera.GetWorldViewMatrix(&HIVMatrixComplete(&ObjPos, &D3DXVECTOR3(time*.7f-(D3DX_PI/2.f), time*.4f, time*.3f), 1.f)));
	Effects.Get()->SetFloatArray("CameraVector", CameraVector, 3);
	Effects.Get()->SetTexture("tex0", CubeMaps.Get("cubemap"));
	Effects.BeginEffect(0);
	MongoObj.RenderMesh();
	Effects.EndEffect();
*/

	/*** Ground *******************************************************************************************************************/
	float commonY = -200.f;

	if(time>146.3f)
	{
		float d = (time-146.3f);
		float c = ((146.3f-time)*D3DX_PI);
		commonY +=  Clamp(d, 0.f, 1.f)*100.f;
		commonY += ((1.f-Clamp(d*.3f, 0.f, 1.f))*20.f)*sinf(c*2);
	}

	Effects.SetRef("ground2");
	Effects.Get()->SetMatrix("matWorldView", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, commonY, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), 1.0f)*camera.GetViewMatrix()));
	Effects.Get()->SetMatrix("matLightViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, commonY, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), 2.0f)*hore.GetViewProjectionMatrix()) );
	Effects.Get()->SetTexture("tex0", Textures.Get("bigred"));
	Effects.Get()->SetTexture("tex1", CubeMaps.Get("cubemap"));
	Effects.Get()->SetTexture("tex2", ShadowMap.Texture);
	//Effects.Get()->SetTexture("tex2", Text.Get("you"));
	Effects.Get()->SetFloatArray("LightPosition", light.Position, 3);
	Effects.Get()->SetFloat("TextureSpeed",  time*GBSPEED*-.1f);
	
	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_CW, false);
	//out line
	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, commonY, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), 2.016f)*camera.GetViewProjectionMatrix()));
	Effects.BeginEffect(1);
	GroundPlane.RenderMeshDoubleBuffer();
	Effects.EndEffect();
	

	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_CW, true);
	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(0.f,commonY, 0.f), &D3DXVECTOR3(0.f, D3DX_PI/2.f, 0.f), 2.00f)*camera.GetViewProjectionMatrix()));
	Effects.BeginEffect(0);
	GroundPlane.RenderMesh();
	Effects.EndEffect();

		/***objekt*****************************************************************************/
	D3DXVECTOR3 CameraVector;
	D3DXVec3Normalize(&CameraVector, &(camera.Position-camera.Target));
	HIVCullModeZ(D3DCULL_CCW, true);
	HIVAlpha(false);
	Effects.SetRef("obj1");
	Effects.Get()->SetMatrix("matWorldViewProjection", &camera.GetWVPMatrix(&HIVMatrixComplete(&ObjPos, &D3DXVECTOR3(time*.7f, time*.4f, time*.3f), ObjScl)));
	Effects.Get()->SetMatrix("matWorldView", &camera.GetWorldViewMatrix(&HIVMatrixComplete(&ObjPos, &D3DXVECTOR3(time*.7f-(D3DX_PI/2.f), time*.4f, time*.3f), 1.f)));
	Effects.Get()->SetFloatArray("CameraVector", CameraVector, 3);
	Effects.Get()->SetTexture("tex0", CubeMaps.Get("cubemap"));
	Effects.BeginEffect(0);
	MongoObj.RenderMesh();
	Effects.EndEffect();
}



void Scene2Simple(float time)
{
	/***sky***********************************************************************************/
	skycamera.SetCamera(D3DXVECTOR3(-40.f, 20.f, 0.f), D3DXVECTOR3(0.f, 25.f, 0.f), D3DX_PI/3.8f);
	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", & (HIVMatrixComplete(&D3DXVECTOR3(-00.f, -220.f, -00.f), &D3DXVECTOR3(time*.7f, 0.f, 0.f), 1.f)*skycamera.GetViewProjectionMatrix()));
	Effects.Get()->SetTexture("tex0", Textures.Get("bigred"));
	Effects.Get()->SetFloat("alpha", .7f);
	Effects.BeginEffect(1);
	Meshes.Get("hemi")->RenderMesh();
	Effects.EndEffect();
}
void Scene1Simple(float time)
{
	skycamera.SetCamera(D3DXVECTOR3(-40.f, 20.f, 0.f), D3DXVECTOR3(0.f, 25.f, 0.f), D3DX_PI/3.8f);
	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&D3DXVECTOR3(0.f, -220.f, 0.f), &D3DXVECTOR3(time*.7f, 0.f, 0.f), 1.f)*skycamera.GetViewProjectionMatrix()));
	Effects.Get()->SetTexture("tex0", Textures.Get("colormap"));
	Effects.Get()->SetFloat("alpha", .7f);
	Effects.BeginEffect(1);
	Meshes.Get("hemi")->RenderMesh();
	Effects.EndEffect();
}
void Scene2End(float time)
{

	/***sky***********************************************************************************/
	skycamera.SetCamera(D3DXVECTOR3(-40.f, 20.f, 0.f), D3DXVECTOR3(0.f, 25.f, 0.f), D3DX_PI/3.8f);
	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", & (HIVMatrixComplete(&D3DXVECTOR3(-00.f, -220.f, -00.f), &D3DXVECTOR3(time*.7f, 0.f, 0.f), 1.f)*skycamera.GetViewProjectionMatrix()));
	Effects.Get()->SetTexture("tex0", Textures.Get("bigred"));
	Effects.Get()->SetFloat("alpha", .7f);
	Effects.BeginEffect(1);
	Meshes.Get("hemi")->RenderMesh();
	Effects.EndEffect();
	/***Normal piss**************************************************************************************/

	device->EndScene();
	
	FloatMap.BeginScene();

	device->Clear(0, NULL,D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0xffffffff, 1.f, 0);

	float mtime = D3DX_PI/2.f;
	camera.SetCamera(D3DXVECTOR3(-200.f*sinf(mtime), 45.f, -200.f*cosf(mtime)), D3DXVECTOR3(00.f, 0.f, 00.f), D3DX_PI/3.2f);
	
	D3DXVECTOR3 cm =  camera.Target-camera.Position;
	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_CCW, true);
	Effects.SetRef("normal");
	Effects.Get()->SetTexture("tex0", CubeMaps.Get("cubemap"));
	Effects.Get()->SetFloatArray("camera", cm, 3);
	
	Effects.BeginEffect(0);
	
	float sync = 1.f;//pow(fft.Gain(3.1f, .01f, time)+1.f, 2);
	float canim = time*.1f;
	for(int i=0;i<40.f;i++)
	{
		float seed = PerlinNoise(i*i*61324*i);
		D3DXVECTOR3 pos = D3DXVECTOR3(40.f + (seed*60.f)*cosf(i+(time*seed)+(seed*523144.f)), 
			60.f+(seed*60.f)*sinf(i+(time*seed)+(seed*72435.f))-50.f, 
			10.f+(seed*60.f)*sinf(cosf(i)+(time*seed)+(seed*7241234135.f)));

		float s =  (abs(sinf(seed+time))+2.f) *cosf(time+(seed*624.f));
		s = Clamp(s, 0.f, 3.f);

		s*=sync;

		D3DXVECTOR3 rot = D3DXVECTOR3(0.f, 0.f, 0.f);
		Effects.Get()->SetMatrix("matWorldViewProjection", &(HIVMatrixComplete(&pos, &rot,s )*camera.GetViewProjectionMatrix()));
		rot.x -= (D3DX_PI/2.f);
		Effects.Get()->SetMatrix("matWorldView", &(HIVMatrixComplete(&pos, &rot, 1.f)*camera.GetViewMatrix()));

		Effects.Get()->CommitChanges();
		meshSphere.RenderMesh();
	}
	Effects.EndEffect();

	FloatMap.EndScene();

	//BlurNormals
	FloatMap2.BeginScene();

	HIVAlpha(false);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("blur");
	Effects.Get()->SetMatrix("matProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", FloatMap.Texture);
	Effects.Get()->SetFloat("blur", 1.8f);
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();
	
	FloatMap2.EndScene();
	device->BeginScene();

	//DrawTexture

	float alphav = 1.f;

	HIVAlpha(true);
	HIVCullModeZ(D3DCULL_NONE, false);
	Effects.SetRef("normal");
	Effects.Get()->SetMatrix("matProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex1", FloatMap2.Texture);
	Effects.Get()->SetTexture("tex0", CubeMaps.Get("cubemap"));
	Effects.Get()->SetTexture("tex2", Textures.Get("test"));
	//Effects.Get()->SetTexture("tex2", Textures.Get("bigred"));
	Effects.Get()->SetFloat("alphavalue", alphav);
	Effects.BeginEffect(1);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();

}