float4x4 matWorldViewProjection;
float4x4 matWorldView;
float4x4 matLightViewProjection; 
float3   LightPosition = {100.f, -100.f, 00.f};
float    TextureSpeed = 0.f;

texture tex0;
sampler NormalMap = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Wrap; AddressV = Wrap;
};
texture tex1;
sampler DiffuseMap = 
sampler_state
{
	texture = (tex1);
	MipFilter = None; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};
texture tex2;
sampler ShadowMap = 
sampler_state
{
	texture = (tex2);
	MipFilter =Point; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};

void vs_ground1(in  float4 ipos : POSITION,
				in  float2 itex : TEXCOORD0,
				in  float3 normal : NORMAL,
				out float4 opos : POSITION,
				out float2 otex : TEXCOORD0,
				out float3 onormal : TEXCOORD1,
				out float3 lightdir : TEXCOORD2,
				out float2 nmtex : TEXCOORD3,
				out float4 lightpos : TEXCOORD4 )
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex; otex.y += 1.f;
	nmtex = itex+float2(0.f, TextureSpeed);
	
	onormal = (mul(normalize(normal), matWorldView)); 
	
	lightdir = normalize(LightPosition - mul(ipos, matWorldView));
	lightpos = mul(ipos, matLightViewProjection);
	
};

float4 ps_ground1(in float2 texcoord : TEXCOORD0,
				  in float3 normal : TEXCOORD1,
				  in float3 lightdir: TEXCOORD2,
				  in float2 nmtex : TEXCOORD3,
				  in float4 lightpos : TEXCOORD4) : COLOR0
{

	float2 spot = .5f*lightpos.xy/lightpos.w + float2(.5f, .5f);
	spot.y = 1.f - spot.y;

	//normal.y -= 1.f;
	float4 fogish = .02f*pow(texCUBE(DiffuseMap, normal), 1.0f);

	float diffuselight = dot(normal, lightdir); 
	float4 hey = (1.f-tex2D(ShadowMap, spot))+.6f;
	float4 color = tex2D(NormalMap, texcoord);
	
	//return hey;
	return (diffuselight)*(color+fogish)*hey;//*fogish);//*hey;//*tex2D(DiffuseMap, texcoord);
};

/*********************************************************************************************************/

void vs_ground2(in float4 ipos : POSITION,
				out float4 opos : POSITION)
{
	opos = mul(ipos, matWorldViewProjection);
}

float4 ps_ground2() : COLOR0
{
	return float4(1.f, 1.f, 1.f, 0.f);
}


/**********************************************************/

float4 ps_alpha1() : COLOR0
{
	return float4(0.f, 0.f, 0.f, 1.f);
}

technique ground1 
{
	pass p0
	{
		VertexShader = compile vs_2_0 vs_ground1();
		PixelShader  = compile ps_2_0 ps_ground1();
	}
	
	pass p1
	{
		VertexShader = compile vs_2_0 vs_ground2();
		PixelShader  = compile ps_2_0 ps_ground2();
	}
	
	pass OutL0Alpha
	{
		VertexShader = compile vs_2_0 vs_ground2();
		PixelShader  = compile ps_2_0 ps_alpha1();
	}
}