

float4x4 WorldViewProjection : WORLDVIEWPROJECTION;
float4x4 ViewInv : VIEWINVERSE;
float4x4 World : WORLD;

texture texture1 : DiffuseMap <
    string ResourceName = "c:/oma/alt/spacek.jpg";
    string UIName = "Diffuse Texture";
    string ResourceType = "2D";
>;
texture alphaTexture : DiffuseMap <
    string ResourceName = "c:/oma/alt/spacek.jpg";
    string UIName = "Diffuse Texture";
    string ResourceType = "2D";
>;

texture envTexture : DiffuseMap;

float4 lightDir : Direction <
    string Object = "DirectionalLight";
    string Space = "World";
> = {1.0f, -1.0f, 1.0f, 0.0f};

//float4x4 WorldIT : WorldInverseTranspose;
float4x4 WorldIT : ViewInverse;


struct VS_OUTPUT
{
	float4 pos  : POSITION;
	float4 col : Color0;
	float2 tex1 : TEXCOORD0;
	half4 position: TEXCOORD1;
	half3 normal: TEXCOORD2;
};

VS_OUTPUT VS(
	float4 pos1 : POSITION,
	float4 col : Color0,
	float2 tex1 : TEXCOORD0
	) 
{
	VS_OUTPUT Out;
	
	Out.col = col;
	Out.pos = mul( pos1, WorldViewProjection );
	Out.tex1.x = tex1.x;
	Out.tex1.y = tex1.y;
	Out.position = Out.pos;

	Out.normal = 0;
	return Out;
}


VS_OUTPUT VS_light(
	float4 pos1 : POSITION,
	float4 col : Color0,
	float2 tex1 : TEXCOORD0,
	float3 Normal	: NORMAL
	) 
{
	VS_OUTPUT Out;
	
float3 fj = normalize( pos1 ).xyz;
//	float3 Nn = normalize(mul(fj, WorldIT).xyz);
	float3 Nn = normalize(mul(Normal, WorldViewProjection  ).xyz);
    float3 Ln = normalize(lightDir); 
    float ldn = dot(Ln,Nn);
    float diffComp = max(0.0,ldn);
//    diffComp = min( 0.25, diffComp );
//    diffComp = min( 1, diffComp );
//    diffComp = max( 1, diffComp );
diffComp = 1;
    
	Out.col = diffComp.xxxx;
	Out.pos = mul( pos1, WorldViewProjection );
	Out.tex1.x = tex1.x;
	Out.tex1.y = tex1.y;
	Out.position = Out.pos;
	Out.normal = Nn;

	return Out;
}

VS_OUTPUT VS_light2(
	float4 pos1 : POSITION,
	float4 col : Color0,
	float2 tex1 : TEXCOORD0,
	float3 Normal	: NORMAL
	) 
{
	VS_OUTPUT Out;
	
	float3 Nn = normalize(mul(Normal, WorldIT).xyz);
    float3 Ln = normalize(lightDir); 
    float ldn = abs(dot(Ln,Nn));
    float diffComp = max(0,ldn);
//    diffComp = min( 1, diffComp );
//    diffComp = max( 1, diffComp );
    
	Out.col = diffComp.xxxx;
	Out.pos = mul( pos1, WorldViewProjection );
	Out.tex1.x = tex1.x;
	Out.tex1.y = tex1.y;
	Out.position = Out.pos;
	
	Out.normal = normalize(mul(Normal, WorldViewProjection).xyz);


	return Out;
}



sampler smp1 = sampler_state 
{
	texture = (texture1);
	AddressU  = CLAMP;
	AddressV  = CLAMP;
	AddressW  = CLAMP;
/*	AddressU  = WRAP;
	AddressV  = WRAP;
	AddressW  = WRAP;*/
	MIPFILTER = NONE;
	MINFILTER = LINEAR;
	MAGFILTER = LINEAR;
};

sampler smp3 = sampler_state 
{
	texture = (envTexture);
	AddressU  = WRAP;        
	AddressV  = WRAP;
	AddressW  = WRAP;
	MIPFILTER = NONE;
	MINFILTER = LINEAR;
	MAGFILTER = LINEAR;
};

sampler smp2 = sampler_state 
{
	texture = (alphaTexture);
	AddressU  = WRAP;        
	AddressV  = WRAP;
	AddressW  = WRAP;
	MIPFILTER = NONE;
	MINFILTER = LINEAR;
	MAGFILTER = LINEAR;
};


float4 PS(VS_OUTPUT In) : COLOR
{
//  return In.col;
//	return tex2D( smp1, In.tex1.xy );// * In.col;
	return tex2D( smp1, In.tex1 );
	
}

float4 PS_light_alphaTex(VS_OUTPUT In) : COLOR
{
	float4 t = tex2D( smp1, In.tex1 );
//	t.xyz = float3(1,1,1);
//	t *= In.col;
	t.xyz *= In.col.xyz;
	t.a = 1-tex2D( smp2, In.tex1 ).r;
	return t;	
}

float4 PS_light_env_alphaTex(VS_OUTPUT In) : COLOR
{
	float4 t = tex2D( smp1, In.tex1 );
//	t.xyz = float3(1,1,1);
//	t *= In.col;
	t.xyz *= In.col.xyz;
	t.a = 1-tex2D( smp2, In.tex1 ).r;
	
	return t;	
}
float4 PS_light_env_alphaTex_pass2(VS_OUTPUT In) : COLOR
{
	float2 dir = reflect( normalize(In.position.xyz),  In.tex1 );
		
	return tex2D( smp3, dir );
}


float4 PS_light(VS_OUTPUT In) : COLOR
{
	float4 t = tex2D( smp1, In.tex1 );
	t.xyz *= In.col.xyz;
	return t;	
}

float4 PS_line(VS_OUTPUT In) : COLOR
{
	return In.col;	
}


technique main
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0};

		Lighting = false;
		cullmode = none;
        
	}
}

technique main_zenable
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = true;
		ZWriteEnable = true;
		ZFunc = LessEqual;
		cullmode = ccw;
		
/*		ZEnable = true;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0};

		Lighting = false;
		cullmode = none;*/
        
	}
}
technique light
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS_light();
		PixelShader = compile ps_2_0 PS_light();
		
		ZEnable = true;
		ZWriteEnable = true;
		ZFunc = LessEqual;
		cullmode = ccw;
        
	}
}
technique light_2sided
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS_light2();
		PixelShader = compile ps_2_0 PS_light();
		
		ZEnable = false;
		ZWriteEnable = false;
		ZFunc = LessEqual;
		cullmode = none;
        
	}
}
technique alphaTex
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS_light();
		PixelShader = compile ps_2_0 PS_light_alphaTex();
		
		ZEnable = false;
		ZWriteEnable = false;
		ZFunc = LessEqual;
        
		AlphaBlendEnable = true;
      	DESTBLEND = INVSRCALPHA;
		SRCBLEND = SRCALPHA;
	}
}
technique alphaEnvTex
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS_light();
		PixelShader = compile ps_2_0 PS_light_env_alphaTex();
		
		ZEnable = false;
		ZWriteEnable = false;
		ZFunc = LessEqual;
        
		AlphaBlendEnable = true;
      	DESTBLEND = INVSRCALPHA;
		SRCBLEND = SRCALPHA;
	}
	pass p1
	{
		VertexShader = compile vs_2_0 VS_light();
		PixelShader = compile ps_2_0 PS_light_env_alphaTex_pass2();
		
		ZEnable = false;
		ZWriteEnable = false;
		ZFunc = LessEqual;
        
		AlphaBlendEnable = false;
      	DESTBLEND = ONE;
		SRCBLEND = SRCALPHA;
	}
}
technique alpha
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0}; 

		AlphaBlendEnable = true;
      	DESTBLEND = INVSRCALPHA;
		SRCBLEND = SRCALPHA;
		Lighting = false;
//		cullmode = none;
        
	}
}
technique additive
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0}; 

		AlphaBlendEnable = true;
      	DESTBLEND = ONE;
		SRCBLEND = SRCALPHA;
		Lighting = false;
//		cullmode = none;
        
	}
}
technique subtract
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0}; 

		AlphaBlendEnable = true;
      	DESTBLEND = INVSRCCOLOR;
		SRCBLEND = ZERO;
		Lighting = false;
//		cullmode = none;
        
	}
}

technique debug
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0}; 

		Lighting = false;
        
	}
	pass p1
	{
		FillMode = wireframe;
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS_line();
		
		AlphaBlendEnable = true;
		BlendOp = add;
		DestBlend = srcalpha;
		SrcBlend = invsrcalpha;
	}
	pass p2
	{
		FillMode = point;
		pointscaleEnable = false;
		pointsize = 6;
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS_line();
		
		AlphaBlendEnable = false;
	}
}
