
texture texture1;

float4x4 World : WORLD;
float4x4 View : VIEW;
float4x4 Projection : PROJECTION;
float time : TIME;
float4 z;

float position;


struct VS_OUTPUT
{
	float4 pos  : POSITION;
	float4 col : Color0;
	float2 tex1 : TEXCOORD0;
	float4 position: TEXCOORD1;
};

VS_OUTPUT VS(
	float4 pos1 : POSITION,
	float4 col : Color0,
	float2 tex1 : TEXCOORD0
	) 
{
	VS_OUTPUT Out;
	
	Out.col = col;
	Out.pos = mul( pos1, World*View*Projection );
	Out.tex1 = tex1;
	Out.position = Out.pos;

	return Out;
}


sampler smp1 = sampler_state 
{
	texture = (texture1);
	AddressU  = CLAMP;        
	AddressV  = CLAMP;
	AddressW  = CLAMP;
	MIPFILTER = NONE;
	MINFILTER = LINEAR;
	MAGFILTER = LINEAR;
};

 

float4 PS(VS_OUTPUT In) : COLOR
{
	float4 c1 = tex2D( smp1, In.tex1.xy );
  
	return c1;
	
}

float4 PS_line(VS_OUTPUT In) : COLOR
{
	float c = cos(abs(time*14)) * 0.5 + 0.5;
	float a = 0.1*sin(time*28);
	return float4(c,c,c,0.8-a);
	
}


technique main
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 0.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0}; 

		Lighting = false;
		cullmode = none;
        
	}
}

technique debug
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0}; 

		Lighting = false;
        
	}
	pass p1
	{
		FillMode = wireframe;
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS_line();
		
		AlphaBlendEnable = true;
		BlendOp = add;
		DestBlend = srcalpha;
		SrcBlend = invsrcalpha;
	}
	pass p2
	{
		FillMode = point;
		pointscaleEnable = false;
		pointsize = 6;
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS_line();
		
		AlphaBlendEnable = false;
	}
}
