//**************************************************************//
//  Effect File exported by RenderMonkey 1.6
//
//  - Although many improvements were made to RenderMonkey FX  
//    file export, there are still situations that may cause   
//    compilation problems once the file is exported, such as  
//    occasional naming conflicts for methods, since FX format 
//    does not support any notions of name spaces. You need to 
//    try to create workspaces in such a way as to minimize    
//    potential naming conflicts on export.                    
//    
//  - Note that to minimize resulting name collisions in the FX 
//    file, RenderMonkey will mangle names for passes, shaders  
//    and function names as necessary to reduce name conflicts. 
//**************************************************************//

//--------------------------------------------------------------//
// Effect Group 1
//--------------------------------------------------------------//
//--------------------------------------------------------------//
// Effect1
//--------------------------------------------------------------//
//--------------------------------------------------------------//
// Pass 0
//--------------------------------------------------------------//
string Effect_Group_1_Effect1_Pass_0_Model : ModelData = "..\\..\\..\\..\\..\\..\\Program Files\\ATI Research Inc\\RenderMonkey 1.62\\Examples\\Media\\Models\\Sphere.3ds";

texture renderTexture_Tex : RenderColorTarget
<
   float2 ViewportRatio={1.0,1.0};
   string Format="D3DFMT_A8R8G8B8";
   float  ClearDepth=1.000000;
   int    ClearColor=-16777216;
>;
float4x4 matViewProjection : ViewProjection;
float3   LightPos
<
   string UIName = "LightPos";
   string UIWidget = "Numeric";
   bool UIVisible =  false;
   float UIMin = -1.00;
   float UIMax = 1.00;
> = float3( 1.00, -0.96, 0.48 );

struct VS_INPUT 
{
   float4 Position : POSITION0;
   float2 TexCoord : TEXCOORD0;
   
};

struct VS_OUTPUT 
{
   float4 Position : POSITION0;
   float2 TexCoord : TEXCOORD0;   
   float2 TexCoord2 : TEXCOORD1;
   float3 Diffuse : COLOR;
};

VS_OUTPUT Effect_Group_1_Effect1_Pass_0_Vertex_Shader_vs_main( VS_INPUT Input )
{
   VS_OUTPUT Output;

   Output.Position = mul( Input.Position, matViewProjection );
   float2 ts = Input.TexCoord;
   Output.TexCoord = ts;// - float2(ts.x%0.3,ts.y%0.3);
   Output.Diffuse = cross( Output.Position, mul(LightPos,matViewProjection) );
//   Output.TexCoord2 = dot( Output.Position, mul(LightPos,matViewProjection) ).xx;
   Output.TexCoord2 = dot( normalize(Output.Position), LightPos ).xx;
   
   return( Output );
   
}




texture my2DTexture_Tex
<
   string ResourceName = "..\\..\\..\\..\\..\\..\\Program Files\\ATI Research Inc\\RenderMonkey 1.62\\Examples\\Media\\Textures\\Earth.jpg";
>;
sampler Texture0 = sampler_state
{
   Texture = (my2DTexture_Tex);
   ADDRESSU = WRAP;
   ADDRESSV = WRAP;
   MAGFILTER = POINT;
   MINFILTER = POINT;
   MIPFILTER = POINT;
};
float Pixelize
<
   string UIName = "Pixelize";
   string UIWidget = "Numeric";
   bool UIVisible =  false;
   float UIMin = -1.00;
   float UIMax = 1.00;
> = float( 0.04 );

struct Effect_Group_1_Effect1_Pass_0_Pixel_Shader_VS_OUTPUT 
{
   float4 Position : POSITION0;
   float2 TexCoord : TEXCOORD0;   
   float2 TexCoord2 : TEXCOORD1;
   float3 Diffuse : COLOR;
};

float4 Effect_Group_1_Effect1_Pass_0_Pixel_Shader_ps_main( Effect_Group_1_Effect1_Pass_0_Pixel_Shader_VS_OUTPUT In ) : COLOR0
{   
   
   float2 ts = In.TexCoord;
   ts = ts - float2( ts.x % Pixelize, ts.y % Pixelize );
   float2 d = float2( In.TexCoord2.xy );
   float4 k = tex2D( Texture0, ts );
   
   k = tex2D( Texture0, k.xyz );
   
/*   ts = ts - float2( ts.x % Pixelize, ts.y % Pixelize );
   float4 k = tex2D( Texture1, ts );
   k.w = length(k.xyz)>1.5?0:1;*/
   
   k.xyz -= float3(0.7,0.7,0.7);
   k *= 5;
   k = clamp( k, float4(0,0,0,0), float4(1,1,1,1) );
//   k.w = length(k.xyz)>1.5?0:1;
   return k;
//   return( float4( 1.0f, 0.0f, 0.0f, 1.0f ) );
   
}




//--------------------------------------------------------------//
// Pass 1
//--------------------------------------------------------------//
string Effect_Group_1_Effect1_Pass_1_Model : ModelData = "..\\..\\..\\..\\..\\..\\Program Files\\ATI Research Inc\\RenderMonkey 1.62\\Examples\\Media\\Models\\Sphere.3ds";

float4x4 Effect_Group_1_Effect1_Pass_1_Vertex_Shader_matViewProjection : ViewProjection;
float3   Effect_Group_1_Effect1_Pass_1_Vertex_Shader_LightPos
<
   string UIName = "Effect_Group_1_Effect1_Pass_1_Vertex_Shader_LightPos";
   string UIWidget = "Numeric";
   bool UIVisible =  false;
   float UIMin = -1.00;
   float UIMax = 1.00;
> = float3( 1.00, -0.96, 0.48 );

struct Effect_Group_1_Effect1_Pass_1_Vertex_Shader_VS_INPUT 
{
   float4 Position : POSITION0;
   float2 TexCoord : TEXCOORD0;
   
};

struct Effect_Group_1_Effect1_Pass_1_Vertex_Shader_VS_OUTPUT 
{
   float4 Position : POSITION0;
   float2 TexCoord : TEXCOORD0;   
   float3 Diffuse : COLOR;
};

Effect_Group_1_Effect1_Pass_1_Vertex_Shader_VS_OUTPUT Effect_Group_1_Effect1_Pass_1_Vertex_Shader_vs_main( Effect_Group_1_Effect1_Pass_1_Vertex_Shader_VS_INPUT Input )
{
   Effect_Group_1_Effect1_Pass_1_Vertex_Shader_VS_OUTPUT Output;

   Output.Position = mul( Input.Position, Effect_Group_1_Effect1_Pass_1_Vertex_Shader_matViewProjection );
   float2 ts = Input.TexCoord;
//   Output.TexCoord = ts - float2(ts.x%0.13,ts.y%0.13);
//   Output.TexCoord = (float2(ts.x%0.13,ts.y%0.13)) * (1/0.13);
   Output.TexCoord = ts;
   Output.Diffuse = dot( Output.Position, Effect_Group_1_Effect1_Pass_1_Vertex_Shader_LightPos );
   
   return( Output );
   
}




float Effect_Group_1_Effect1_Pass_1_Pixel_Shader_Pixelize
<
   string UIName = "Effect_Group_1_Effect1_Pass_1_Pixel_Shader_Pixelize";
   string UIWidget = "Numeric";
   bool UIVisible =  false;
   float UIMin = -1.00;
   float UIMax = 1.00;
> = float( 0.04 );
sampler Texture1 = sampler_state
{
   Texture = (my2DTexture_Tex);
   MAGFILTER = POINT;
   MIPFILTER = POINT;
   MINFILTER = POINT;
};
struct Effect_Group_1_Effect1_Pass_1_Pixel_Shader_VS_OUTPUT 
{
   float4 Position : POSITION0;
   float2 TexCoord : TEXCOORD0;   
   float3 Diffuse : COLOR;
};

float4 Effect_Group_1_Effect1_Pass_1_Pixel_Shader_ps_main( Effect_Group_1_Effect1_Pass_1_Pixel_Shader_VS_OUTPUT In ) : COLOR0
{   
   
   float2 ts = In.TexCoord;
   float2 pix = float2(0,0);
   if ( Effect_Group_1_Effect1_Pass_1_Pixel_Shader_Pixelize > 0 )
   {
     pix.x = ts.x % Effect_Group_1_Effect1_Pass_1_Pixel_Shader_Pixelize;
     pix.y = ts.y % Effect_Group_1_Effect1_Pass_1_Pixel_Shader_Pixelize;
   }
    
   ts = ts - float2( pix.xy );
   float4 k = tex2D( Texture1, ts );
//   k.w = length(k.xyz)>1.5?0:1;
   return k;
//   return( float4( 1.0f, 0.0f, 0.0f, 1.0f ) );
   
}




//--------------------------------------------------------------//
// Pass 2
//--------------------------------------------------------------//
string Effect_Group_1_Effect1_Pass_2_ScreenAlignedQuad : ModelData = "..\\..\\..\\..\\..\\..\\Program Files\\ATI Research Inc\\RenderMonkey 1.62\\Examples\\Media\\Models\\ScreenAlignedQuad.3ds";

float4x4 Effect_Group_1_Effect1_Pass_2_Vertex_Shader_matViewProjection;
float3   Effect_Group_1_Effect1_Pass_2_Vertex_Shader_LightPos
<
   string UIName = "Effect_Group_1_Effect1_Pass_2_Vertex_Shader_LightPos";
   string UIWidget = "Numeric";
   bool UIVisible =  false;
   float UIMin = -1.00;
   float UIMax = 1.00;
> = float3( 1.00, -0.96, 0.48 );

struct Effect_Group_1_Effect1_Pass_2_Vertex_Shader_VS_INPUT 
{
   float4 Position : POSITION0;
   float2 TexCoord : TEXCOORD0;
   
};

struct Effect_Group_1_Effect1_Pass_2_Vertex_Shader_VS_OUTPUT 
{
   float4 Position : POSITION0;
   float2 TexCoord : TEXCOORD0;   
   float3 Diffuse : COLOR;
};

Effect_Group_1_Effect1_Pass_2_Vertex_Shader_VS_OUTPUT Effect_Group_1_Effect1_Pass_2_Vertex_Shader_vs_main( Effect_Group_1_Effect1_Pass_2_Vertex_Shader_VS_INPUT Input )
{
   Effect_Group_1_Effect1_Pass_2_Vertex_Shader_VS_OUTPUT Out;

//   Output.Position = mul( Input.Position, Effect_Group_1_Effect1_Pass_2_Vertex_Shader_matViewProjection );
//   Output.TexCoord = Input.TexCoord;
//   float2 Pos.xy = sign(Input.Position.xy);
//   float2 Pos.xy = sign(Input.Position.xy);

   Input.Position.xy = sign(Input.Position.xy);

   Out.Position = float4(Input.Position.xy, 0, 1);
   Out.TexCoord = Input.Position.xy * 0.5f;
   Out.TexCoord.x = - 0.5 + Out.TexCoord.x;
   Out.TexCoord.y = 0.5 - Out.TexCoord.y;
   Out.Diffuse = dot( Out.Position, Effect_Group_1_Effect1_Pass_2_Vertex_Shader_LightPos );
//   Out.TexCoord = Input.TexCoord.xy;
   return Out;

/*   float2 Pos;
   Pos.xy = Input.Position.xy;

   Out.Position = float4(Pos.xy, 0, 1);
   Out.Position.xy = Pos.xy;
   Out.TexCoord.x = 0.5 * (1 + Pos.x);
   Out.TexCoord.y = 0.5 * (1 - Pos.y);   
   return( Out );*/
   
   
}




sampler TextureRend = sampler_state
{
   Texture = (renderTexture_Tex);
   MAGFILTER = LINEAR;
   MIPFILTER = LINEAR;
};
struct Effect_Group_1_Effect1_Pass_2_Pixel_Shader_VS_OUTPUT 
{
   float4 Position : POSITION0;
   float2 TexCoord : TEXCOORD0;   
   float3 Diffuse : COLOR;
};
 float2 poisson[8] = {  
  float2( 0.0,      0.0),
  float2( 0.527837,-0.085868),
  float2(-0.040088, 0.536087),
  float2(-0.670445,-0.179949),
  float2(-0.419418,-0.616039),
  float2( 0.440453,-0.639399),
  float2(-0.757088, 0.349334),
  float2( 0.574619, 0.685879)
};

float texScale = 1.0/128.0;


float4 Effect_Group_1_Effect1_Pass_2_Pixel_Shader_ps_main( Effect_Group_1_Effect1_Pass_2_Pixel_Shader_VS_OUTPUT In ) : COLOR0
{   
  float4 c1 = float4(0,0,0,0);
//  float f = (In.position.y % 10) / 9.0f; 
//  c1 = tex2D( smp1, In.tex1.xy + 2.0f*poisson[0] * texScale ).xyzw * f;
  for ( int a=0; a<8; a++ )
  {
     c1 += tex2D( TextureRend, In.TexCoord.xy + 1.5f*poisson[a] * texScale ).xyzw;
  }
  for ( int a=0; a<8; a++ )
  {
     c1 += tex2D( TextureRend, In.TexCoord.xy + 3.0f*poisson[a] * texScale ).xyzw * 0.5f;
  }
  c1 /= 12.0f;
//  c1.w = 1;
//  c1.w = 1/length( c1.xyz );
   return c1;
//   return tex2D( TextureRend, In.TexCoord );
//   return( float4( 1.0f, 0.0f, 0.0f, 1.0f ) );
   
}




//--------------------------------------------------------------//
// Technique Section for Effect Group 1
//--------------------------------------------------------------//
technique Effect1
{
   pass Pass_0
   <
      string Script = "RenderColorTarget0 = renderTexture_Tex;"
                      "ClearColor = (0, 0, 0, 255);"
                      "ClearDepth = 1.000000;";
   >
   {
      LIGHTING = FALSE;
      ZENABLE = FALSE;

      VertexShader = compile vs_2_0 Effect_Group_1_Effect1_Pass_0_Vertex_Shader_vs_main();
      PixelShader = compile ps_2_0 Effect_Group_1_Effect1_Pass_0_Pixel_Shader_ps_main();
   }

   pass Pass_1
   {
      CULLMODE = NONE;
      SRCBLEND = SRCALPHA;
      SRCBLENDALPHA = SRCALPHA;
      DESTBLEND = INVSRCALPHA;
      DESTBLENDALPHA = ONE;
      ALPHABLENDENABLE = TRUE;

      VertexShader = compile vs_2_0 Effect_Group_1_Effect1_Pass_1_Vertex_Shader_vs_main();
      PixelShader = compile ps_2_0 Effect_Group_1_Effect1_Pass_1_Pixel_Shader_ps_main();
   }

   pass Pass_2
   {
      CULLMODE = NONE;
      ALPHABLENDENABLE = TRUE;
      SRCBLEND = SRCALPHA;
      SRCBLENDALPHA = SRCALPHA;
      DESTBLEND = ONE;
      DESTBLENDALPHA = ONE;

      VertexShader = compile vs_2_0 Effect_Group_1_Effect1_Pass_2_Vertex_Shader_vs_main();
      PixelShader = compile ps_2_a Effect_Group_1_Effect1_Pass_2_Pixel_Shader_ps_main();
   }

}

