
float4x4 worldviewproj : WORLDVIEWPROJECTION;


//////////////////////////////////////////////////

float time : TIME;

struct VS_IN
{
	float4 pos : POSITION;
	float3 nor : NORMAL;
	float2 tex : TEXCOORD0;
};

struct VS_OUT
{
	float4 pos : POSITION;
	float3 nor : TEXCOORD0;
	float2 tex : TEXCOORD1;
	float3 lightDir : TEXCOORD2;
};


texture effectTexture
<
	string Format = "X8R8G8B8";
> ;
sampler effectSampler = sampler_state { 
    texture = <effectTexture>; 
    MipFilter = POINT;
    MinFilter = LINEAR; 
    MagFilter = LINEAR; 
};
texture normalTex
<
	string Format = "X8R8G8B8";
> ;
sampler normalSampler = sampler_state { 
    texture = <normalTex>; 
    MipFilter = POINT;
    MinFilter = LINEAR; 
    MagFilter = LINEAR; 
};


float3 lightDir
<
	string UIName = "light direction";	
>;

float4 diffuseColor
<
	string UIName = "light color";
	string UIWidget = "color";
> = float4(1,1,1,1);

float4 ambientColor
<
	string UIName = "ambient color";
	string UIWidget = "color";
> = float4(0,0,0,1);

float lightPower
<
	string UIName = "light power";
	string UIWidget = "slider";
	float UIMin = 0.0;
	float UIMax =20.0;
	float UIStep= 0.1;
> = 4.0;

float diffuseAmount
<
	string UIName = "light intensity";
	string UIWidget = "slider";
	float UIMin = 0.0;
	float UIMax =20.0;
	float UIStep= 0.1;
> = 1.4;

//////////////////////////////////////////////////

VS_OUT VS ( VS_IN input )
{
	VS_OUT ret;
	
	float4 pos = input.pos;
	float4 nor = float4( input.nor.x, input.nor.y, input.nor.z, 1);
	
	ret.pos = mul ( pos, worldviewproj );
	ret.nor = mul ( input.nor, worldviewproj );
	ret.tex = input.tex;
//	ret.lightDir = mul( lightDir, worldviewproj);	
	ret.lightDir = lightDir;

	return ret;
}

float4 PS ( VS_OUT input ) : COLOR
{
	
	float4 texColor = tex2D ( effectSampler, input.tex);
	
	float4 amb = ambientColor * texColor;
	float light = dot ( input.nor, input.lightDir);
	
	float4 dif = pow ( diffuseColor * light , lightPower ) * diffuseAmount;
	float4 result = amb;
	if( light > 0.0)
		result.xyz += 0.6f * texColor.xyz * dif.xyz + 0.4f * dif;
		
	return result;
	
}
float4 PS_bump ( VS_OUT input ) : COLOR
{
	
	return float4(0,0,0,0);
}

//////////////////////////////////////////////////


technique directionalLight
{
	pass P0
	{
		// texture + light
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
 		CullMode = none;
		StencilEnable = false;
		ZWriteEnable = true;
		ZFunc = LessEqual;
		ZEnable = true;
		TwoSidedStencilMode = false;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		AlphaBlendEnable = true;
	//	alphatest = true;
//		alpharef = 0.9;
		StencilWriteMask = 0;
		StencilFunc = Always;
	}
	
	
}


