

float4x4 WorldViewProjection : WORLDVIEWPROJECTION;

texture texture1 : DiffuseMap <
    string ResourceName = "c:/oma/alt/spacek.jpg";
    string UIName = "Diffuse Texture";
    string ResourceType = "2D";
>;


struct VS_OUTPUT
{
	float4 pos  : POSITION;
	float4 col : Color0;
	float2 tex1 : TEXCOORD0;
	float4 position: TEXCOORD1;
};

VS_OUTPUT VS(
	float4 pos1 : POSITION,
	float4 col : Color0,
	float2 tex1 : TEXCOORD0
	) 
{
	VS_OUTPUT Out;
	
	Out.col = col;
	Out.pos = mul( pos1, WorldViewProjection );
	Out.tex1 = tex1;
	Out.position = Out.pos;

	return Out;
}

VS_OUTPUT VS_flip(
	float4 pos1 : POSITION,
	float4 col : Color0,
	float2 tex1 : TEXCOORD0
	) 
{
	VS_OUTPUT Out;
	
	Out.col = col;
	Out.pos = mul( pos1, WorldViewProjection );
	Out.tex1.x = tex1.x;
	Out.tex1.y = tex1.y;
	Out.position = Out.pos;

	return Out;
}


sampler smp1 = sampler_state 
{
	texture = (texture1);
	AddressU  = WRAP;        
	AddressV  = WRAP;
	AddressW  = WRAP;
	MIPFILTER = NONE;
	MINFILTER = LINEAR;
	MAGFILTER = LINEAR;
};


float4 PS(VS_OUTPUT In) : COLOR
{
//return float4(1,1,1,1);
//  return In.col;
//	return tex2D( smp1, In.tex1.xy );// * In.col;
	return tex2D( smp1, In.tex1 );
	
}

float4 PS_line(VS_OUTPUT In) : COLOR
{
	return In.col;	
}


technique main
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0};

		Lighting = false;
		cullmode = none;
        
	}
}


technique mainEi
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		ZWriteEnable = false;
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0};

		Lighting = false;
		cullmode = none;
        
	}
}

technique main_zenable
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS_flip();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = true;
		ZWriteEnable = true;
		ZFunc = LessEqual;
		
/*		ZEnable = true;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0};

		Lighting = false;
		cullmode = none;*/
        
	}
}
technique alpha
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0}; 

		AlphaBlendEnable = true;
      	DESTBLEND = INVSRCALPHA;
		SRCBLEND = SRCALPHA;
		Lighting = false;
//		cullmode = none;
        
	}
}
technique additive
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0}; 

		AlphaBlendEnable = true;
      	DESTBLEND = ONE;
		SRCBLEND = SRCALPHA;
		Lighting = false;
//		cullmode = none;
        
	}
}
technique subtract
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0}; 

		AlphaBlendEnable = true;
      	DESTBLEND = INVSRCCOLOR;
		SRCBLEND = ZERO;
		Lighting = false;
//		cullmode = none;
        
	}
}

technique debug
{
	pass p0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
		
		ZEnable = false;	
		MaterialAmbient = {0.0, 0.0, 0.0, 0.0}; 
		MaterialDiffuse = {1.0, 1.0, 1.0, 1.0}; 
		MaterialSpecular = {1.0, 1.0, 1.0, 1.0}; 

		Lighting = false;
        
	}
	pass p1
	{
		FillMode = wireframe;
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS_line();
		
		AlphaBlendEnable = true;
		BlendOp = add;
		DestBlend = srcalpha;
		SrcBlend = invsrcalpha;
	}
	pass p2
	{
		FillMode = point;
		pointscaleEnable = false;
		pointsize = 6;
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS_line();
		
		AlphaBlendEnable = false;
	}
}
