float Script : STANDARDSGLOBAL <
    string UIWidget = "none";
    string ScriptClass = "object";
    string ScriptOrder = "standard";
    string ScriptOutput = "color";
    string Script = "Technique=DirectX9;";
> = 0.8;

/************* TWEAKABLES **************/

half4x4 WorldIT : WorldInverseTranspose < string UIWidget = "None"; >;
half4x4 WorldViewProj : WorldViewProjection < string UIWidget = "None"; >;
half4x4 World : World < string UIWidget = "None"; >;
half4x4 ViewInv : ViewInverse < string UIWidget = "None"; >;
float Time : TIME ;//<string UIWidget="None";>;

////////////////////////////////////////////// lamp 1

float4 LightPos : Direction <  
	string UIName = "Light Direction"; 
	string Object = "TargetLight";
	int RefID = 0;
	> = {-0.577, -0.577, 0.577,1.0};
/*
float4 LightPos : Position <
    string Object = "Pointlight";
    string Space = "World";
    int RefID = 0;
> = {1.0f, 1.0f, -1.0f, 0.0f};
*/
half4 LightColor1 : Specular <
    string UIName =  "Light1 Color";
    string Object = "Pointlight";
    string UIWidget = "Color";
> = {1.0f, 1.0f, 1.0f, 1.0f};

half LightIntensity1
<
    string UIWidget = "slider";
    half UIMin = 1.0;
    half UIMax = 50.0;
    half UIStep = 0.1;
    string UIName =  "lamp1 power";
> = 2.0;

////////////////////////////////////////////// lamp 2

half4 LightPos2 : Position
<
    string Object = "Pointlight";
    string Space = "World";
> = {-1.0f, 0.0f, 1.0f, 0.0f};

half4 LightColor2 : Specular <
    string UIName =  "Light2 Color";
    string Object = "Pointlight";
    string UIWidget = "Color";
> = {0.5f, 0.5f, 1.0f, 1.0f};


half LightIntensity2
<
    string UIWidget = "slider";
    half UIMin = 1.0;
    half UIMax = 50.0;
    half UIStep = 0.1;
    string UIName =  "lamp2 power";
> = 0.5;

////////////////////////////////////////////// surface

float envPos;

half4 AmbiColor : Ambient <
    string UIName =  "Ambient Light Color";
    string UIWidget = "Color";
> = {0.07f, 0.07f, 0.07f, 1.0f};

half4 SurfColor : Diffuse
<
    string UIName =  "Surface Color";
    string UIWidget = "Color";
> = {1.0f, 1.0f, 1.0f, 1.0f};

half Kd <
    string UIWidget = "slider";
    half UIMin = 0.0;
    half UIMax = 1.5;
    half UIStep = 0.01;
    string UIName =  "diffuse";
> = 1.0;

half Ks <
    string UIWidget = "slider";
    half UIMin = 0.0;
    half UIMax = 1.5;
    half UIStep = 0.01;
    string UIName =  "specular";
> = 1.0;


half SpecExpon : SpecularPower <
    string UIWidget = "slider";
    half UIMin = 1.0;
    half UIMax = 128.0;
    half UIStep = 1.0;
    string UIName =  "specular power";
> = 12.0;

half bumpiness <
    string UIWidget = "slider";
    half UIMin = 0.0;
    half UIMax = 10.0;
    half UIStep = 0.1;
    string UIName =  "bumpiness";
> = 1.0;

half Kr <
    string UIWidget = "slider";
    half UIMin = 0.0;
    half UIMax = 1.5;
    half UIStep = 0.01;
    string UIName =  "Reflection Max";
> = 1.0;


half KrMin <
    string UIWidget = "slider";
    half UIMin = 0.0;
    half UIMax = 0.2;
    half UIStep = 0.001;
    string UIName =  "Reflection Min";
> = 0.002;

half FresExp : SpecularPower <
    string UIWidget = "slider";
    half UIMin = 1.0;
    half UIMax = 7.0;
    half UIStep = 0.1;
    string UIName =  "edging";
> = 5.0;

/////////////////////////////////

texture colorTexture : DiffuseMap <
    string ResourceName = "c:/oma/alt/earthmap1k.jpg";
    string UIName = "Diffuse Texture";
    string ResourceType = "2D";
>;

texture normalTexture : NORMAL <
    string ResourceName = "worldheight.jpg";
    string UIName = "bump Texture";
    string ResourceType = "2D";
>;

texture glossTexture : SPECULAR <
    string ResourceName = "earthlights1k.jpg";
    string UIName = "gloss Texture";
    string ResourceType = "2D";
>;

//texture envTexture : ENVIRONMENT <
texture envTexture : DiffuseMap <
    string ResourceName = "earthcloudmap.jpg";
    string UIName = "env Texture";
    string ResourceType = "2D";
>;

////////

sampler2D colorSampler = sampler_state {
	Texture = <colorTexture>;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU = Wrap;
	AddressV = Wrap;
};

sampler2D normalSampler = sampler_state {
	Texture = <normalTexture>;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU = Wrap;
	AddressV = Wrap;
};

sampler2D glossSampler = sampler_state {
	Texture = <glossTexture>;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU = Wrap;
	AddressV = Wrap;
};

//samplerCUBE
sampler2D envSampler = sampler_state {
	Texture = <envTexture>;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU = wrap;
	AddressV = wrap;
};

/************* DATA STRUCTS **************/

/* data from application vertex buffer */
struct appdata {
    half3 Position	: POSITION;
    half4 UV		: TEXCOORD0;
    half4 Normal	: NORMAL;
    half4 Tangent	: TANGENT0;
    half4 Binormal	: BINORMAL0;
};

/* data passed from vertex shader to pixel shader */
struct vertexOutput {
    half4 HPosition	: POSITION;
    half4 TexCoord	: TEXCOORD0;
    float4 LightVec1	: TEXCOORD1;
    half3 WorldNormal	: TEXCOORD2;
    half3 WorldPos	: TEXCOORD3;
    half3 WorldEyePos	: TEXCOORD4;
    half3 WorldTangent	: TEXCOORD5;
    half3 WorldBinorm	: TEXCOORD6;
    half4 Pos	: TEXCOORD7;
};

/*********** vertex shader ******/

vertexOutput mainVS(appdata IN) {
    vertexOutput OUT;
    OUT.WorldNormal = mul(IN.Normal, WorldIT).xyz;
    OUT.WorldTangent = mul(IN.Tangent, WorldIT).xyz;
    OUT.WorldBinorm = mul(IN.Binormal, WorldIT).xyz;
    float4 tempPos = float4(IN.Position.xyz,1.0);
    float3 worldSpacePos = mul(tempPos, World).xyz;
    OUT.WorldPos = worldSpacePos;
    half3 L1 = LightPos - worldSpacePos;
    half3 L2 = LightPos2 - worldSpacePos;
    half Ld1 = 1.0/length(L1);
    half Ld2 = 1.0/length(L2);
//    OUT.LightVec1 = half4(-L1.xyz,Ld1);
//    OUT.LightVec1 = mul(LightPos,World);// * OUT.WorldNormal;
//    OUT.LightVec1 = normalize( mul( OUT.WorldTangent, normalize(LightPos-worldSpacePos) ) );
//    OUT.LightVec1 = dot( normalize(mul(LightPos, WorldIT)),
//        normalize(mul(IN.Normal,WorldIT)) );
    OUT.LightVec1 = dot(LightPos, OUT.WorldNormal);
//    OUT.LightVec2 = half4(L2.x,L2.y,L2.z,Ld2);
    OUT.TexCoord = IN.UV;
    OUT.WorldEyePos = ViewInv[3].xyz;
    OUT.HPosition = mul(tempPos, WorldViewProj);
    OUT.Pos = tempPos;
    return OUT;
}

vertexOutput mainVS2(appdata IN) {
    vertexOutput OUT;
    OUT = mainVS( IN );
    
    float4 tempPos = float4(IN.Position.xyz*1.03,1.0);
    float3 worldSpacePos = mul(tempPos, World).xyz;
    OUT.WorldPos = worldSpacePos;
    OUT.HPosition = mul(tempPos, WorldViewProj);
    OUT.Pos = tempPos;
    return OUT;
}

half4 mainPS2(vertexOutput IN) : COLOR 
{
    float4 li = IN.LightVec1;
    float3 norm_ = normalize( IN.WorldPos ).xyz;
    
  float3 tc = IN.TexCoord.xyz;
  float3 env = float3(envPos,0,0);
  half4 p = tex2D( envSampler, tc + env * 0.7 );
  p *= tex2D( envSampler, tc + env * 0.85 );
  p *= tex2D( envSampler, tc + env * 0.9 );
  p *= tex2D( envSampler, tc + env * 1.0 );
    float g = dot( IN.LightVec1, float4(norm_,1) );
    p.w = clamp( g,0,1 ) * tex2D( envSampler, tc + env * 0.4 ).x * length(p.xyz);;
//  p.w = tex2D( envSampler, tc + env * 0.4 ).x * length(p.xyz);
  return p;
  
/*  float3 tc = IN.TexCoord.xyz + float3(envPos,0,0);
  tc.y = sin( tc.x + envPos ) * tc.y;
  tc = mul( tc, WorldIT );
  half4 p = tex2D( envSampler, tc );
  
//    float3 ang = cross(float4(norm_,1),li);
    float g = dot( IN.LightVec1, float4(norm_,1) );
    p.w = clamp( g,0,1 ) * p.x;
    p.xyz = tex2D( envSampler, IN.TexCoord.xyz - float3(envPos,0,0) ).xyz;
    return p;*/
    
  p.w = (1+dot( normalize(mul(IN.WorldPos,WorldViewProj)), normalize(IN.LightVec1) )) * 0.5* p.x;
  p.w = clamp( p.w, 0, 1 );
  return p;
  
//  float ts = dot( normalize(-IN.WorldNormal), normalize(IN.LightVec1) ) * 1;
    float te = cos(-dot( normalize(mul(IN.WorldTangent,WorldIT)), normalize(IN.LightVec1) )) + 1;
    te /= 2.0f;
//  p *= clamp(te,0,1);
  
//    p *= te + max( 0, (0.9-te)*5.0f );    
//    p = max( 0, p * 0.2f );
    float G = li;// * 0.5;
    p *= G;
    
    p.w = G;//clamp(te,0,1);
       
    
  return p;
}

/********* pixel shader ********/

half4 mainPS(vertexOutput IN) : COLOR {

    half3 eye = IN.WorldEyePos;
    half3 norm = IN.WorldNormal;
    
    half3 h = norm;
    
    half3 norm_ = normalize( norm );

    float depth = tex2D( normalSampler, IN.TexCoord.xy ).x;
//    depth += tex2D( normalSampler, IN.TexCoord.xy + float2(0.001,-0.001) ).w;
//    depth *= 0.5;
    
//     half3 kdr = half3(1,1,1);
//    float3 D = ( IN.Pos-mul(eye,ViewInv) );
    float3 D = IN.Pos - eye;
    float3 kdr = D;
    D *= -0.001;
    
/*    half3 kdr = IN.Pos.xyz-eye.xyz;
    kdr = mul( kdr, ViewInv );
    float2 D = normalize(kdr.xyz).xy * depth * 0.1f; 
*/
//    float k = 0.005f;// * dot(IN.Pos, IN.WorldPos );
    float k = bumpiness;
    float3 b;
/*    b.x = 
          tex2D( normalSampler, IN.TexCoord.xy + norm.xy * k ).x
        - tex2D( normalSampler, IN.TexCoord.xy - norm.xy * k ).x;
    b.y = 
          tex2D( normalSampler, IN.TexCoord.xy + norm.xz * k ).x
        - tex2D( normalSampler, IN.TexCoord.xy - norm.xz * k ).x;
        */
//    b.z = 
//          tex2D( normalSampler, IN.TexCoord.xy + norm.yz * k ).x
//        - tex2D( normalSampler, IN.TexCoord.xy - norm.yz * k ).x;

/*    b.x = normalize
        (
          tex2D( normalSampler, IN.TexCoord.xyz - float3(k,0,0) * kdr ).x
        - tex2D( normalSampler, IN.TexCoord.xyz + float3(k,0,0) * kdr ).x
        );
    b.y = normalize
        (
          tex2D( normalSampler, IN.TexCoord.xyz - float3(0,k,0) * kdr ).x
        - tex2D( normalSampler, IN.TexCoord.xyz + float3(0,k,0) * kdr ).x
        );*/
//    b.z = norm.z;
    float3 bd = IN.LightVec1.xyz * k;
    b.x = 
          tex2D( normalSampler, IN.TexCoord.xy + bd.xy ).x
        - tex2D( normalSampler, IN.TexCoord.xy - bd.xy ).x;
    b.y = 
          tex2D( normalSampler, IN.TexCoord.xy + bd.xz ).x
        - tex2D( normalSampler, IN.TexCoord.xy - bd.xz ).x;
        
    b.z = 1;
    b = normalize(b);

//    float2 D = mul( b+norm_, ViewInv ), xy;
//    float2 D = normalize( eye- norm_ ).xy;
//    float3 D = (mul(normalize(norm_+b),ViewInv)*depth).xyz;
//    D = float3(0.5,0.5,0.5) - D;

      float ldn = dot( norm_, normalize(IN.LightVec1.xyz) );
      half4 map = tex2D(colorSampler,IN.TexCoord.xyz + float3(1,1,1)-b*ldn*bumpiness);

    float3 lv1 = normalize(IN.LightVec1.xyz);
//    lv1 = 0.5*lv1 + 0.5.xxx;
//    float g = max( dot( b, lv1 ), 0);
    float ts = max( dot( normalize(IN.WorldNormal), lv1 ), 0 );
//    g *= ts;
/*
	float3 lightVector = 2 * (IN.LightVec1 - 0.5 );
	lightVector = normalize(lightVector);
    float g = dot(mul(b.xyz,WorldIT),lightVector.xyz);
//    lv1 = (normalize(IN.LightVec1.xyz)-normalize(eye.xyz)) * (norm_+b);
//    float g = dot( lv1, norm_+b );
    
    map *= half4( g.xxx + AmbiColor, 1 );*/
    
    float4 li = IN.LightVec1;
    float3 ang = cross(float4(norm_,1),li);
    float g = dot( IN.LightVec1, ang );
//    float g = dot( IN.LightVec1-IN.Pos, norm_+b );
    g = clamp(g,0,1);
//    g = b.x;
//    map = half4( g.xxx + AmbiColor, 1 );
//    map = half4( IN.LightVec1 );
    
    float3 glow = tex2D( glossSampler, IN.TexCoord.xy );
//    float ts1 = clamp(1.0f-dot(norm_,lv1),0,1);
/*    float ts1 = ts;
    glow *= ts1;
    map += half4( glow.xyz, 0 );*/
    
//    float te = abs(-dot( normalize(IN.WorldEyePos), normalize(IN.LightVec2) ));//*0.4f + 0.6f;;
/*    half4 clouds = tex2D( envSampler, IN.TexCoord.xy + half2(Time,0) );
//    ts1 = dot( normalize(-IN.WorldNormal), normalize(IN.LightVec1) ) * 1;
//    clouds *= te + max( 0, (0.9-te)*5.0f );
    clouds *= ts;
    map = map + max( 0, clouds * 0.4f );
//    map += min( tex2D( envSampler, IN.TexCoord.xy + float2(Time,0) ) * ts1, half4(0,0,0,0) );
*/    
//      map = half4(D.xxx, 1);
    
    float G = (dot(b.xyz,li.xyz) + 1) * 0.5;
     
    return (map * float4(G.xxx,1) + glow.xxxx * float4( (1.0f-G).xxx,1 )) * 1.3;
    return float4(G.xxx,1);
      return map;// * li * float4(b.xxx,1);// * SurfColor;// * LightIntensity1;// + AmbiColor;
/*      
      
  //    b = float3(0.5, 0.5, 0.5) - b;
    float g = length( norm - b );
//    half4 result = pow( tex2D( colorSampler, IN.TexCoord ) * g + 0.5, bumpiness );
    g = length( cross( norm, normalize(b) ).xy );
    half4 result = tex2D( colorSampler, IN.TexCoord );// * bumpiness * g;
    
//    result = tex2D( envSampler, IN.TexCoord.xy + float2(Time,0) );    

    result.w = 1.0f;
    
    float te = abs(-dot( normalize(IN.WorldEyePos), normalize(IN.LightVec2) ));//*0.4f + 0.6f;;
//    float ts = dot( normalize(-IN.WorldNormal), normalize(IN.LightVec1) ) * 1;
    float ts = dot( normalize(-IN.WorldNormal), normalize(b) );
    result *= te;
    result *= float4(ts,ts,ts,1);

//    half4 clouds = tex2D( envSampler, IN.TexCoord.xy + float2(0,Timer) ); 
//    half4 clouds = tex2D( envSampler, IN.TexCoord + half4(Timer,0,0,0));

/*    half4 clouds = tex2D( envSampler, IN.TexCoord.xy + float2(Timer*0.01f,0) );
    clouds *= te + max( 0, (0.9-te)*5.0f );
    
    result = result + max( 0, clouds * 0.2f );*/
    
//    result = clouds;

//    result += half4( tex2D( glossSampler, IN.TexCoord.xy ).xyz, 0 );
  
//    return float4(b.xyz,1);  
//    return result;
}

/*************/

technique DirectX9 <
	string Script = "Pass=p0;";
> {
	pass p0 <
	string Script = "Draw=geometry;";
> {
		VertexShader = compile vs_2_0 mainVS();
		ZEnable = false;
		ZWriteEnable = false;
    Lighting = false;
		CullMode = CW;
		PixelShader = compile ps_2_b mainPS();
	}
	pass p1 <
	string Script = "Draw=geometry;";
> {
		VertexShader = compile vs_2_0 mainVS2();
		ZEnable = false;
		ZWriteEnable = false;
    Lighting = false;
		CullMode = CW;
      ALPHABLENDENABLE = TRUE;
      SRCBLEND = SRCALPHA;
      SRCBLENDALPHA = ONE;
      DESTBLEND = INVSRCALPHA;
      DESTBLENDALPHA = ONE;
		PixelShader = compile ps_2_b mainPS2();
	}
}

/***************************** eof ***/
