uniform extern float gTime : XDL2SF_CUSTOM_0;
uniform extern float4x4 gWorld : XDL2SM_WORLD;

texture g_Texture : XDL2ST_TEXTURE_0;
texture g_Texture2 : XDL2ST_TEXTURE_1;
texture g_Texture3 : XDL2ST_TEXTURE_2;

sampler texSample = sampler_state
{
	Texture = <g_Texture>;

    	MinFilter = Anisotropic;
    	MagFilter = Linear;
    
    	MaxAnisotropy = 2;
};

sampler texSample2 = sampler_state
{
	Texture = <g_Texture2>;

    	MinFilter = Anisotropic;
    	MagFilter = Linear;
    
    	MaxAnisotropy = 2;
};

sampler texSample3 = sampler_state
{
	Texture = <g_Texture3>;

    	MinFilter = Anisotropic;
    	MagFilter = Linear;
    
    	MaxAnisotropy = 2;
};

float3 getCoord(float2 texcoord)
{
    float3 pos = float3(texcoord,0.0f)*8.0f;
    float3 posw = mul(float4(pos,1.0f),gWorld).xyz;
    float z = (sin(posw.x) + sin(posw.y))/2;
    return float3(posw.x,posw.y,z);	
}

float4 pixelShader(float2 texcoord : TEXCOORD0) : COLOR
{
	float3 p0 = tex2D(texSample,texcoord).xyz;
	float3 p1 = tex2D(texSample2,texcoord).xyz;
	float3 p2 = tex2D(texSample3,texcoord).xyz;

	float3 e1 = p2-p0;
	float3 e2 = p1-p0;

	float3 norm = normalize(cross(e1,e2));

	float3 dir = normalize(p0-float3(0.0f,0.0f,0.0f));

	float d = max(dot(dir,norm),0.0f);
	
	float sc = 0.0f;

	if(p0.z > 0.1f)
		sc = 1.0f;

	return float4(norm,1.0f)*sc;
}

float4 normalShader0(float2 texcoord : TEXCOORD0) : COLOR
{
	texcoord = (-0.5f+texcoord)*2;

	float3 p0 = getCoord(texcoord);

	return float4(p0,1.0f);
}

float4 normalShader1(float2 texcoord : TEXCOORD0) : COLOR
{
    	texcoord = (-0.5f+texcoord)*2;

    	float3 p1 = getCoord(texcoord + float2(0.1f,0.0f));

   	return float4(p1,1.0f);
}

float4 normalShader2(float2 texcoord : TEXCOORD0) : COLOR
{
	texcoord = (-0.5f+texcoord)*2;

	float3 p2 = getCoord(texcoord + float2(0.0f,0.1f));	

	return float4(p2,1.0f);
}


technique Fx
{
	Pass P0
	{
		vertexShader = Null;
		pixelShader = compile ps_2_0 normalShader0();
		ZEnable = FALSE;
		ZWriteEnable = FALSE;
	}

	Pass P1
	{
		vertexShader = NULL;
		pixelShader = compile ps_2_0 normalShader1();
		ZEnable = FALSE;
		ZWriteEnable = FALSE;
	}

	Pass P2
	{
		vertexShader = NULL;
		pixelShader = compile ps_2_0 normalShader2();
		ZEnable = FALSE;
		ZWriteEnable = FALSE;
	}

	Pass P3
	{
		vertexShader = NULL;
		pixelShader = compile ps_2_0 pixelShader();
		ZEnable = FALSE;
		ZWriteEnable = FALSE;
	}
}