uniform extern float4x4 g_WVP 	     : XDL2SM_WORLD_VIEW_PROJECTION;
uniform extern float4x4 g_World	     : XDL2SM_WORLD;
uniform extern float4x4 g_WorldIT    : XDL2SM_WORLD_INVERSE_TRANSPOSE;
uniform extern float4x4 g_View       : XDL2SM_VIEW;

uniform extern float4 g_Ambient  : XDL2SV_MATERIAL_AMBIENT;
uniform extern float4 g_Diffuse  : XDL2SV_MATERIAL_DIFFUSE;
uniform extern float4 g_Specular : XDL2SV_MATERIAL_SPECULAR;
uniform extern float4 g_Emissive : XDL2SV_MATERIAL_EMISSIVE;

uniform extern float4 g_EyePos : XDL2SV_EYE_POSITION;

uniform extern texture g_Texture : XDL2ST_TEXTURE_1;
uniform extern float4x4 g_TextM  : XDL2SM_TEXTURE_1_TRANSFORM;

uniform extern texture g_Texture2 : XDL2ST_TEXTURE_2;

uniform extern float4 g_Lights[4] : XDL2SV_LIGHT_POSITION;
uniform extern float4 g_LightColors[4] : XDL2SV_LIGHT_COLOR;

uniform extern float g_Scale : XDL2SF_CUSTOM_0 = 1.0f;

#include "Base/light.fxh"

float gTime : XDL2SF_CUSTOM_0;

sampler texSample = sampler_state
{
	Texture = <g_Texture>;

    	MinFilter = Anisotropic;
    	MagFilter = Linear;
    
    	MaxAnisotropy = 8;
};

sampler texSample2 = sampler_state
{
	Texture = <g_Texture2>;

    	MinFilter = Anisotropic;
    	MagFilter = Anisotropic;
    
    	MaxAnisotropy = 8;
};

struct VertexShaderOut
{
	float4 pos  : POSITION0;
	float3 normal  : TEXCOORD0;
	float3 posW : TEXCOORD1;
	float2 tex : TEXCOORD2;
	float4 oz : TEXCOORD3;
};

VertexShaderOut VertexShader(float3 posa : POSITION0, float3 normal : NORMAL0, float2 tex : TEXCOORD0)
{
	VertexShaderOut vso = (VertexShaderOut)0;

	vso.normal = normal;
	
	posa *= g_Scale;
	vso.pos = mul( float4(posa,1.0f), g_WVP );
	vso.posW = mul( float4(posa,1.0f), g_World );
	vso.normal = mul( float4(normal,0.0f), g_WorldIT );
	vso.tex = mul(tex,g_TextM);

	return vso;
}

float4 PixelShader(float3 normal : TEXCOORD0, float3 pos : TEXCOORD1, float2 tex : TEXCOORD2, float4 oz : TEXCOORD3) : COLOR
{
	normal = normalize(normal);
	
	float3 toEye = normalize(g_EyePos-pos);

	float3 lightVec = normalize(g_Lights[0].xyz-pos);
	float4 pdiff = (LightDiffuse(normal,lightVec)*g_LightColors[0]);
	float4 pspec = LightSpec(normal,lightVec,toEye,16);

	lightVec = normalize(g_Lights[1].xyz-pos);
	pdiff += (LightDiffuse(normal,lightVec)*g_LightColors[1]);
	pspec += LightSpec(normal,lightVec,toEye,16);

	float4 texc = tex2D(texSample,tex);	
	float4 col = (g_Diffuse*pdiff*texc)+pspec*g_Specular;
	float4 fin = (col+g_Emissive);

	return	fin;
}

technique Shader
{
	pass P0
	{
		vertexShader = compile vs_2_0 VertexShader();
		pixelShader = compile ps_2_0 PixelShader();
		//CullMode = None;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
		//BlendOp = Add;
	}
}

