uniform extern float4x4 g_WVPMatrix  : XDL2SM_WORLD_VIEW_PROJECTION;
uniform extern texture  g_Texture    : XDL2ST_TEXTURE_0;

float4x4 gWorld : XDL2SM_WORLD;
float4 gEye : XDL2SV_EYE_POSITION;
float gScale : XDL2SF_CUSTOM_0 = 1.0f;
float gTime : XDl2SF_CUSTOM_1 = 1.0f;

sampler texSample = sampler_state
{
	Texture = <g_Texture>;

	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = LINEAR;
};

struct VertexShaderOut
{
	float4 pos  : POSITION0;
	float2 tex  : TEXCOORD0;
	float4 color : COLOR0;
	float size : PSIZE;
};

VertexShaderOut VertexShader(float3 pos : POSITION0, float size : TEXCOORD0, float4 color : COLOR0)
{
	VertexShaderOut vso = (VertexShaderOut)0;
	
	
	pos *= gScale;
	float3 posw = mul(float4(pos,1.0f),gWorld);
	float rot = gTime*4;
	pos.x += sin(pos.z+rot) - cos(pos.z+rot);
	pos.z += cos(pos.y+rot) + sin(pos.y+rot);
	vso.pos = mul( float4(pos,1.0f), g_WVPMatrix );
	vso.size = (size/vso.pos.z)*6;

	float dst =  distance(gEye, posw)*0.01;
	vso.color = lerp(color,float4(0.0f,0.0f,0.0f,0.0f),dst);
	return vso;
}

float4 PixelShader(float2 tex : TEXCOORD0, float4 color : COLOR0) : COLOR
{	

	float4 texcol = tex2D(texSample,tex);
	float4 col = (8*tex.x*tex.y*texcol.w)+texcol;
	col.w = texcol.w;
	return (color*(col));
}

technique Mask
{
	pass P0
	{
		vertexShader = compile vs_2_0 VertexShader();
		pixelShader = compile ps_2_0 PixelShader();

		AlphaBlendEnable = TRUE;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
		BlendOp = Add;
		ZEnable = FALSE;
	}
}

