uniform extern texture  g_Texture  : XDL2ST_TEXTURE_0;
uniform extern float g_Time : XDL2SF_CUSTOM_0;

sampler texSample = sampler_state
{
	Texture = <g_Texture>;

	MinFilter = LINEAR;
	MagFilter = LINEAR;
	AddressU = Wrap;	
	AddressV = Wrap;
};

float4 pixelShader(float2 texc : TEXCOORD0) : COLOR
{

	float z = sin(texc.x + g_Time)*0.1f;

	texc+=z;

	return tex2D(texSample,texc);
}

technique Fx
{
	Pass P0
	{
		vertexShader = Null;
		pixelShader = compile ps_2_0 pixelShader();
		ZEnable = FALSE;
		ZWriteEnable = FALSE;
	}
}