varying vec2 texCoord;
uniform sampler2D baseMap;
uniform float anim;
varying vec3 norm;
varying vec3 eye;
void main()
{

	float checker = texCoord.y;
	if((checker) > anim)
		discard;
	vec4 col = texture2D(baseMap,reflect(normalize(eye),normalize(norm)).xy*0.5);
	vec3 lightVec = vec3(0.0,0.7,0.3);
	
	float lVal = max(dot(normalize(lightVec),normalize(norm)),0.3);
	
	float lightRec = length(eye);
	lightRec = 1.0/(lightRec*0.03);
	lightRec=0.4;
	lightRec=lVal;
	float at2 = 1.0/((texCoord.y - anim)*460.9);
	vec3 annenShading = vec3(lightRec+ vec3(at2));
	gl_FragColor = vec4(col.rgb*annenShading,1.0);//vec4(lightRec*at2*0.8,lightRec*at2*0.8,lightRec*at2*0.9,1.0);
}