varying vec2 texCoord;
uniform sampler2D baseMap;
uniform sampler2D noiseMap;
uniform samplerCube envMap;

varying vec3 varyEyeVec;
varying vec3 varyTangent;
varying vec3 varyBiNormal;
varying vec3 varyNormal;
varying vec3 varyLight;

void main()
{

	vec4 col = texture2D(baseMap,texCoord*0.1);
	vec3 bump = texture2D(noiseMap,texCoord*0.7);
	float lightRec = max(dot(normalize(varyLight),normalize(bump)),0.2);
	vec3 envCol = textureCube(envMap,reflect(normalize(varyEyeVec),normalize(bump))).rgb;
	float lumi = envCol.r/3.0 + envCol.b/3.0 + envCol.g/3.0;
	lumi = pow(lumi,8.0);
	float attenuation = length(varyEyeVec)*0.001;
	attenuation = 1.0/attenuation;
	attenuation = 1.0;
	gl_FragColor = (col*lightRec+lumi)*attenuation;

}