float fWidth = 800 * 0.01f;
float fHeight = 600 * 0.01f;

float4 vColor;
float4x4 mWorld;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
    AddressU = Clamp; AddressV = Clamp;
};


struct SInput {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	float4 pos = mul( i.pos, mWorld );
	o.pos = float4( pos.x / fWidth * 2, pos.z / fHeight * 2, 0, 1 );
	o.tex = i.tex;
	return o; 
}

technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = NULL;
	
		//FillMode = Wireframe;
		//FillMode = Solid;

		ZEnable = False;
		ZWriteEnable = False;		

		//ZEnable = True;
		//ZWriteEnable = True;
		CullMode = None; 

		AlphaBlendEnable = True;
		//AlphaBlendEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;		

		Sampler[0] = (smpBase);

		TextureFactor = <vColor>;
		//TextureFactor = 0x88ffffff;

		/*ColorOp[0] = SelectArg2;
		//ColorOp[0] = Modulate;
		//ColorArg1[0] = Texture;
		ColorArg2[0] = TFactor;
		AlphaOp[0] = SelectArg2;
		//AlphaOp[0] = Modulate;
		//AlphaArg1[0] = Texture;
		AlphaArg2[0] = TFactor; */

		ColorOp[0] = Modulate;
		ColorArg1[0] = Texture;
		ColorArg2[0] = TFactor;
		AlphaOp[0] = Modulate;
		AlphaArg1[0] = Texture;
		AlphaArg2[0] = TFactor;

		ColorOp[1] = Disable;
		AlphaOp[1] = Disable; 		

		SeparateAlphaBlendEnable = True;
		SrcBlendAlpha = One;
		DestBlendAlpha = One;
	}
}

	