float fWidth = 800;
float fHeight = 600;

float4 vColor;

struct SInput {
	float4 pos : POSITION;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	o.pos = float4( i.pos.x / fWidth * 2 - 1, i.pos.y / fHeight * 2 - 1, i.pos.z, 1 );
	return o; 
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = NULL;
		
		ZEnable = False;
		ZWriteEnable = False;
		CullMode = None;

		AlphaBlendEnable = True;
		//AlphaBlendEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		TextureFactor = <vColor>;
			
		ColorOp[0] = SelectArg1;
		ColorArg1[0] = TFactor;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = TFactor;
		
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable; 		
	}
}

	