#include "ZenitShared.fx"

float4 vColor;

struct SInput {
	float4 pos : POSITION;
	float4 index : BLENDINDICES;
//        float3 normal : NORMAL;
};

struct SOutput
{
	float4 pos : POSITION;
//	float4 diffuse : COLOR0;
};


SOutput RenderSceneVS( SInput i )
{
	SOutput o;

	float3 pos;	

	gSkinning( i.pos, i.index, pos );	
	
	o.pos = mul( float4( pos, 1 ), mVP );

	return o;   
}

technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = NULL;
		
		AlphaBlendEnable = False;
		//AlphaBlendEnable = True;
		//SrcBlend = SrcAlpha;
		//DestBlend = InvSrcAlpha;

		//SeparateAlphaBlendEnable = True;
		//SrcBlendAlpha = One;
		//DestBlendAlpha = One;
	
		
		CullMode = <iCull>;

		//ZEnable = False;
		ZEnable = True;
		ZWriteEnable = True;

		//TextureFactor = 0xffcccccc;
		//TextureFactor = 0xff444444;
		//TextureFactor = 0xff4d5747; // 0xff64705b; //0xff5c704f;
		TextureFactor = <vColor>;

		ColorOp[0] = SelectArg1;
		ColorArg1[0] = TFactor;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = TFactor;
		
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
}
