#include "ZenitShared.fx"

texture tBase;
float4x4 mWorld;

sampler BaseSampler = sampler_state {
    Texture = <tBase>;    
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
	float4 index : BLENDINDICES;
        float3 normal : NORMAL;
        float2 tex : TEXCOORD0;
};

struct SOutput
{
    float4 pos : POSITION;
    float4 diffuse : COLOR0;
    float2 tex : TEXCOORD0;
};


float calcDiffuse(float3 Normal, float3 DirToLight)
{
    return max(0, dot(Normal, DirToLight));
}

float calcSpecular(float3 Normal, float3 DirFromLight, float3 EyeToVertex)
{
	float materialSpecularPower = 10;
    float3 R = normalize(reflect(DirFromLight, Normal));
    return pow(max(0, dot(R, -EyeToVertex)), materialSpecularPower/4);
}



SOutput RenderSceneVS( SInput i )
{
	SOutput o;
	
	float3 normal, pos;
	
	//gSkinning( i.pos, i.normal, i.index, pos, normal );
	pos = mul( i.pos, mWorld );   
	normal = normalize( mul( i.normal, (float3x3)mWorld ) ); 
	
	o.pos = mul( float4( pos, 1 ), mVP );
		
	//float d = max( 0, dot( normal, gLightDir ) );
	//o.diffuse.rgb = d * d * d * d * d * d * 2.5f + 0.1f;   
	//o.diffuse.a = 1.0f; 
	
	float3 eyeToVertex = normalize( pos - vCameraPos );
	
	float diff = calcDiffuse( normal, -gLightDir); 
	float spec = calcSpecular( normal, gLightDir, eyeToVertex );
	o.diffuse.a = diff * 0.1f + spec * 0.9f + 0.1f;
	o.diffuse.a *= 0.5;
	o.diffuse.rgb = 1;
	//o.diffuse.rgb = normal * 0.5 + 0.5; //- float3( 0.5, 0.5, 0.5 );
	
		
	o.tex = i.tex; 
	
	return o;   
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		//PixelShader  = compile ps_1_1 RenderScenePS();
		PixelShader  = NULL;
		
		AlphaBlendEnable = True;
		//AlphaBlendEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		SeparateAlphaBlendEnable = True;
		SrcBlendAlpha = One;
		DestBlendAlpha = One;
		
		CullMode = None;

		//ZEnable = False;
		ZEnable = True;
		ZWriteEnable = False;

		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Diffuse;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Diffuse;
		
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
}
