float4x4 mVP;	// View * Projection matrix

float4 vColor;
float4x4 mWorld;

float3 vLight = {-0.4, -0.8, -1};
float3 vEyePos = {0, 0, -1};

struct SInput {
	float4 pos : POSITION;
	float3 normal : NORMAL;
};

struct SOutput
{
	float4 pos : POSITION;
	float3 normal : TEXCOORD0;
	float3 wPos : TEXCOORD1;
};

SOutput RenderSceneVS( SInput i )
{
	SOutput o;
	float4 pos = mul( i.pos, mWorld );
	o.pos = mul( pos, mVP );
	o.normal = mul( i.normal, (float3x3)mWorld );
	o.wPos = pos;
	return o; 
}

float4 RenderScenePS( SOutput i ) : COLOR
{ 
	float4 col;
	col.a = 1;

	float3 ld = normalize(vLight);
	float3 normal = normalize(i.normal);
	
	float3 eye = normalize(vEyePos - i.wPos);
	float3 r = -normal + eye * 2 * dot(eye, normal);


	float diffuse = clamp(dot(normal, ld), 0, 1);
	float specular = pow(clamp(dot(r, ld), 0, 1), 15);

	col.rgb = diffuse * 0.2 + specular * 0.9;
		
	return col;
}

technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_2_0 RenderSceneVS();
		PixelShader  = compile ps_2_0 RenderScenePS();
		
		ZEnable = True;
		ZWriteEnable = True;
		CullMode = None;

		AlphaBlendEnable = False;
	}
}

	