float fWidth = 800 * 0.01f;
float fHeight = 600 * 0.01f;

float4 vColor;
float4x4 mWorld;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	float4 pos = mul( i.pos, mWorld );
	//float4 pos = i.pos;
	o.pos = float4( pos.x / fWidth * 2, pos.z / fHeight * 2, -pos.y / 10 + 0.5, 1 );
	o.tex = (o.pos.xy + 1) / 2;
	o.tex.y = -o.tex.y;
	return o; 
}

technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = NULL;
	
		ZEnable = False;
		ZWriteEnable = False;		

		CullMode = None; 

		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;		

		Sampler[0] = (smpBase);

		TextureFactor = <vColor>;

		ColorOp[0] = Modulate;
		ColorArg1[0] = TFactor;
		ColorArg2[0] = Texture;
		AlphaOp[0] = Modulate;
		AlphaArg1[0] = TFactor;
		AlphaArg2[0] = Texture;

		ColorOp[1] = Disable;
		AlphaOp[1] = Disable; 		
	}
}

	