float fWidth = 800;
float fHeight = 600;

float4 vColor;

float fDist;
float fFactor;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};

texture tMask;
sampler smpMask = sampler_state {
    Texture = <tMask>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
        float2 tex : TEXCOORD0;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	//float4 pos = mul( i.pos, mWorld );
	o.pos = float4( i.pos.x / fWidth * 2 - 1, i.pos.y / fHeight * 2 - 1, 0, 1 );
	o.tex = i.tex;
	//o.tex.x = (i.tex.x - 0.5) * 0.97 + 0.5;
	//o.tex.y = (i.tex.y - 0.5) * 0.97 + 0.5;

	return o; 
}

float4 RenderScenePS( SInput i ) : COLOR
{ 
	float4 col = tex2D( smpBase, i.tex );
	float4 mask = tex2D( smpMask, i.tex );

	float d = fFactor;
	float l = fDist * ( 1 + d * 2 ) - d;

	//float d =0.3;
	//float l = 0.5;
	

	float a = clamp(abs(mask.r - l) / d, 0, 1);
	a = pow(a, 10);
	//col.a *= 1 - a;
	col.a = 1 - a;
	//col.rgb = col.a;
	//col.a = 1;	
	//col.rgb = col.a;
	//col.a = 1;
	return col;
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = compile ps_2_0 RenderScenePS();
	
		ZEnable = False;
		ZWriteEnable = False;		
		CullMode = None; 

		AlphaBlendEnable = True;
		//AlphaBlendEnable = False;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;		

		//FillMode = Solid;		
	}
}

	