float4x4 mVP;
float4x4 mWorld;

float4 vColor;

texture tBase;
sampler smpBase = sampler_state {
    Texture = <tBase>;    
    MipFilter = None; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
};

struct SOutput {
	float4 pos : POSITION;
	float2 tex : TEXCOORD0;
};


SOutput RenderSceneVS( SInput i )
{
	SOutput o;
	//o.pos = mul( mul( i.pos, mWorld ), mVP );

	float4 pos = i.pos;
	pos.xyz *= 100;

	o.pos = mul( pos, mVP );
	o.tex = o.pos.xy / o.pos.w * 0.5 + 0.5;
	o.tex.y = -o.tex.y;
	return o; 
}

technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = NULL;

		//FillMode = Wireframe;		

		ZEnable = False;
		//ZWriteEnable = False;
		CullMode = CW;

		AlphaBlendEnable = False;
		AlphaBlendEnable = True;		
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;		

		Sampler[0] = (smpBase);

		TextureFactor = <vColor>;
		//TextureFactor = 0xcc00ff00;
		                  
		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Texture;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = TFactor;

		ColorOp[1] = Disable;
		AlphaOp[1] = Disable; 		
	}
}

	